/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerValidityRecurrence;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.resourcematcher.ScheduledTimeAlwaysMatcher;
import org.apache.ranger.plugin.resourcematcher.ScheduledTimeExactMatcher;
import org.apache.ranger.plugin.resourcematcher.ScheduledTimeMatcher;
import org.apache.ranger.plugin.resourcematcher.ScheduledTimeRangeMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerValidityScheduleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerValidityScheduleEvaluator.class);
    private static final Logger PERF_LOG = LoggerFactory.getLogger((String)"test.perf.RangerValidityScheduleEvaluator");
    private static final TimeZone defaultTZ = TimeZone.getDefault();
    private static final ThreadLocal<DateFormat> DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
    };
    private final Date startTime;
    private final Date endTime;
    private final String timeZone;
    private final List<RangerRecurrenceEvaluator> recurrenceEvaluators = new ArrayList<RangerRecurrenceEvaluator>();

    public RangerValidityScheduleEvaluator(@Nonnull RangerValiditySchedule validitySchedule) {
        this(validitySchedule.getStartTime(), validitySchedule.getEndTime(), validitySchedule.getTimeZone(), validitySchedule.getRecurrences());
    }

    public RangerValidityScheduleEvaluator(String startTimeStr, String endTimeStr, String timeZone, List<RangerValidityRecurrence> recurrences) {
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotEmpty((CharSequence)startTimeStr)) {
            try {
                startTime = DATE_FORMATTER.get().parse(startTimeStr);
            }
            catch (ParseException exception) {
                LOG.error("Error parsing startTime:[" + startTimeStr + "]", (Throwable)exception);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)endTimeStr)) {
            try {
                endTime = DATE_FORMATTER.get().parse(endTimeStr);
            }
            catch (ParseException exception) {
                LOG.error("Error parsing endTime:[" + endTimeStr + "]", (Throwable)exception);
            }
        }
        this.startTime = startTime;
        this.endTime = endTime;
        String string = this.timeZone = StringUtils.isNotBlank((CharSequence)timeZone) ? timeZone : "GMT";
        if (CollectionUtils.isNotEmpty(recurrences)) {
            for (RangerValidityRecurrence recurrence : recurrences) {
                this.recurrenceEvaluators.add(new RangerRecurrenceEvaluator(recurrence));
            }
        }
    }

    public boolean isApplicable(long accessTime) {
        long endTimeInMSs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("===> isApplicable(accessTime=" + accessTime + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_LOG, "RangerValidityScheduleEvaluator.isApplicable(accessTime=" + accessTime + ")");
        }
        long startTimeInMSs = this.startTime == null ? 0L : this.startTime.getTime();
        long l = endTimeInMSs = this.endTime == null ? 0L : this.endTime.getTime();
        if (StringUtils.isNotBlank((CharSequence)this.timeZone)) {
            TimeZone targetTZ = TimeZone.getTimeZone(this.timeZone);
            if (startTimeInMSs > 0L) {
                startTimeInMSs = RangerValidityScheduleEvaluator.getAdjustedTime(startTimeInMSs, targetTZ);
            }
            if (endTimeInMSs > 0L) {
                endTimeInMSs = RangerValidityScheduleEvaluator.getAdjustedTime(endTimeInMSs, targetTZ);
            }
        }
        if (!(startTimeInMSs != 0L && accessTime < startTimeInMSs || endTimeInMSs != 0L && accessTime > endTimeInMSs)) {
            if (CollectionUtils.isEmpty(this.recurrenceEvaluators)) {
                ret = true;
            } else {
                RangerRecurrenceEvaluator recurrenceEvaluator;
                GregorianCalendar now = new GregorianCalendar();
                now.setTime(new Date(accessTime));
                Iterator<RangerRecurrenceEvaluator> iterator = this.recurrenceEvaluators.iterator();
                while (iterator.hasNext() && !(ret = (recurrenceEvaluator = iterator.next()).isApplicable(now))) {
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<=== isApplicable(accessTime=" + accessTime + ") :" + ret);
        }
        return ret;
    }

    public static long getAdjustedTime(long localTime, TimeZone timeZone) {
        long ret = localTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Input:[" + new Date(localTime) + ", target-timezone" + timeZone + "], default-timezone:[" + defaultTZ + "]");
        }
        if (!defaultTZ.equals(timeZone)) {
            int targetOffset = timeZone.getOffset(localTime);
            int defaultOffset = defaultTZ.getOffset(localTime);
            int diff = defaultOffset - targetOffset;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Offset of target-timezone from UTC :[" + targetOffset + "]");
                LOG.debug("Offset of default-timezone from UTC :[" + defaultOffset + "]");
                LOG.debug("Difference between default-timezone and target-timezone :[" + diff + "]");
            }
            ret += (long)diff;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Output:[" + new Date(ret) + "]");
        }
        return ret;
    }

    static class RangerRecurrenceEvaluator {
        private final List<ScheduledTimeMatcher> minutes = new ArrayList<ScheduledTimeMatcher>();
        private final List<ScheduledTimeMatcher> hours = new ArrayList<ScheduledTimeMatcher>();
        private final List<ScheduledTimeMatcher> daysOfMonth = new ArrayList<ScheduledTimeMatcher>();
        private final List<ScheduledTimeMatcher> daysOfWeek = new ArrayList<ScheduledTimeMatcher>();
        private final List<ScheduledTimeMatcher> months = new ArrayList<ScheduledTimeMatcher>();
        private final List<ScheduledTimeMatcher> years = new ArrayList<ScheduledTimeMatcher>();
        private final RangerValidityRecurrence recurrence;
        private int intervalInMinutes = 0;

        public RangerRecurrenceEvaluator(RangerValidityRecurrence recurrence) {
            this.recurrence = recurrence;
            if (recurrence != null) {
                this.intervalInMinutes = RangerValidityRecurrence.ValidityInterval.getValidityIntervalInMinutes(recurrence.getInterval());
                if (this.intervalInMinutes > 0) {
                    this.addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute, this.minutes);
                    this.addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour, this.hours);
                    this.addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth, this.daysOfMonth);
                    this.addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek, this.daysOfWeek);
                    this.addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month, this.months);
                    this.addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.year, this.years);
                }
            }
        }

        public boolean isApplicable(Calendar now) {
            boolean ret = false;
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_LOG, "RangerRecurrenceEvaluator.isApplicable(accessTime=" + now.getTime().getTime() + ")");
            }
            if (this.recurrence != null && this.intervalInMinutes > 0) {
                Calendar startOfInterval;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Access-Time:[" + now.getTime() + "]");
                }
                if ((startOfInterval = this.getClosestPastEpoch(now)) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Start-of-Interval:[" + startOfInterval.getTime() + "]");
                    }
                    Calendar endOfInterval = (Calendar)startOfInterval.clone();
                    endOfInterval.add(12, this.recurrence.getInterval().getMinutes());
                    endOfInterval.add(10, this.recurrence.getInterval().getHours());
                    endOfInterval.add(5, this.recurrence.getInterval().getDays());
                    endOfInterval.getTime();
                    now.getTime();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("End-of-Interval:[" + endOfInterval.getTime() + "]");
                    }
                    ret = startOfInterval.compareTo(now) <= 0 && endOfInterval.compareTo(now) >= 0;
                }
            } else {
                ret = true;
            }
            RangerPerfTracer.log(perf);
            return ret;
        }

        private void addScheduledTime(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec fieldSpec, List<ScheduledTimeMatcher> list) {
            boolean isMonth;
            String str = this.recurrence.getSchedule().getFieldValue(fieldSpec);
            boolean bl = isMonth = fieldSpec == RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month;
            if (StringUtils.isNotBlank((CharSequence)str)) {
                String[] specs;
                for (String spec : specs = str.split(",")) {
                    String[] range = spec.split("-");
                    if (range.length == 1) {
                        if (StringUtils.equals((CharSequence)range[0], (CharSequence)"*")) {
                            list.clear();
                            list.add(new ScheduledTimeAlwaysMatcher());
                            break;
                        }
                        list.add(new ScheduledTimeExactMatcher(Integer.valueOf(range[0]) - (isMonth ? 1 : 0)));
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)range[0], (CharSequence)"*") || StringUtils.equals((CharSequence)range[1], (CharSequence)"*")) {
                        list.clear();
                        list.add(new ScheduledTimeAlwaysMatcher());
                        break;
                    }
                    list.add(new ScheduledTimeRangeMatcher(Integer.valueOf(range[0]) - (isMonth ? 1 : 0), Integer.valueOf(range[1]) - (isMonth ? 1 : 0)));
                }
                Collections.reverse(list);
            }
        }

        private Calendar getClosestPastEpoch(Calendar current) {
            Calendar ret = null;
            try {
                ValueWithBorrow input = new ValueWithBorrow();
                input.setValue(current.get(12));
                input.setBorrow(false);
                ValueWithBorrow closestMinute = this.getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.minute, this.minutes, input);
                input.setValue(current.get(11));
                input.setBorrow(closestMinute.borrow);
                ValueWithBorrow closestHour = this.getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.hour, this.hours, input);
                Calendar dayOfMonthCalendar = this.getClosestDayOfMonth(current, closestMinute, closestHour);
                Calendar dayOfWeekCalendar = this.getClosestDayOfWeek(current, closestMinute, closestHour);
                ret = this.getEarlierCalendar(dayOfMonthCalendar, dayOfWeekCalendar);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ClosestPastEpoch:[" + (ret != null ? ret.getTime() : null) + "]");
                }
            }
            catch (Exception e) {
                LOG.error("Could not find ClosestPastEpoch, Exception=", (Throwable)e);
            }
            return ret;
        }

        private Calendar getClosestDayOfMonth(Calendar current, ValueWithBorrow closestMinute, ValueWithBorrow closestHour) throws Exception {
            GregorianCalendar ret = null;
            if (StringUtils.isNotBlank((CharSequence)this.recurrence.getSchedule().getDayOfMonth())) {
                int initialDayOfMonth = current.get(5);
                int currentDayOfMonth = initialDayOfMonth--;
                int currentMonth = current.get(2);
                int currentYear = current.get(1);
                int maximumDaysInPreviousMonth = this.getMaximumValForPreviousMonth(current);
                if (closestHour.borrow) {
                    GregorianCalendar dayOfMonthCalc = (GregorianCalendar)current.clone();
                    ((Calendar)dayOfMonthCalc).add(5, -1);
                    dayOfMonthCalc.getTime();
                    int previousDayOfMonth = dayOfMonthCalc.get(5);
                    if (initialDayOfMonth < previousDayOfMonth) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Need to borrow from previous month, initialDayOfMonth:[" + initialDayOfMonth + "], previousDayOfMonth:[" + previousDayOfMonth + "], dayOfMonthCalc:[" + dayOfMonthCalc.getTime() + "]");
                        }
                        currentDayOfMonth = previousDayOfMonth;
                        currentMonth = dayOfMonthCalc.get(2);
                        currentYear = dayOfMonthCalc.get(1);
                        maximumDaysInPreviousMonth = this.getMaximumValForPreviousMonth(dayOfMonthCalc);
                    } else if (initialDayOfMonth == previousDayOfMonth) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No need to borrow from previous month, initialDayOfMonth:[" + initialDayOfMonth + "], previousDayOfMonth:[" + previousDayOfMonth + "]");
                        }
                    } else {
                        LOG.error("Should not get here, initialDayOfMonth:[" + initialDayOfMonth + "], previousDayOfMonth:[" + previousDayOfMonth + "]");
                        throw new Exception("Should not get here, initialDayOfMonth:[" + initialDayOfMonth + "], previousDayOfMonth:[" + previousDayOfMonth + "]");
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("currentDayOfMonth:[" + currentDayOfMonth + "], maximumDaysInPreviourMonth:[" + maximumDaysInPreviousMonth + "]");
                }
                ValueWithBorrow input = new ValueWithBorrow();
                input.setValue(currentDayOfMonth);
                input.setBorrow(false);
                ValueWithBorrow closestDayOfMonth = null;
                do {
                    int i = 0;
                    try {
                        closestDayOfMonth = this.getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfMonth, this.daysOfMonth, input, maximumDaysInPreviousMonth);
                    }
                    catch (Exception e) {
                        GregorianCalendar c = (GregorianCalendar)current.clone();
                        c.set(1, currentYear);
                        c.set(2, currentMonth);
                        c.set(5, currentDayOfMonth);
                        ((Calendar)c).add(2, -(++i));
                        c.getTime();
                        currentMonth = c.get(2);
                        currentYear = c.get(1);
                        currentDayOfMonth = c.get(5);
                        maximumDaysInPreviousMonth = this.getMaximumValForPreviousMonth(c);
                        input.setValue(currentDayOfMonth);
                        input.setBorrow(false);
                    }
                } while (closestDayOfMonth == null);
                ret = new GregorianCalendar();
                ret.set(5, closestDayOfMonth.value);
                ret.set(11, closestHour.value);
                ret.set(12, closestMinute.value);
                ret.set(13, 0);
                ret.set(14, 0);
                ret.set(1, currentYear);
                if (closestDayOfMonth.borrow) {
                    ret.set(2, currentMonth - 1);
                } else {
                    ret.set(2, currentMonth);
                }
                ret.getTime();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Best guess using DAY_OF_MONTH:[" + ret.getTime() + "]");
                }
            }
            return ret;
        }

        private Calendar getClosestDayOfWeek(Calendar current, ValueWithBorrow closestMinute, ValueWithBorrow closestHour) throws Exception {
            GregorianCalendar ret = null;
            if (StringUtils.isNotBlank((CharSequence)this.recurrence.getSchedule().getDayOfWeek())) {
                ValueWithBorrow input = new ValueWithBorrow();
                input.setValue(current.get(7));
                input.setBorrow(closestHour.borrow);
                ValueWithBorrow closestDayOfWeek = this.getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek, this.daysOfWeek, input);
                int daysToGoback = closestHour.borrow ? 1 : 0;
                int range = RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek.maximum - RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.dayOfWeek.minimum + 1;
                if (closestDayOfWeek.borrow) {
                    if (input.value - closestDayOfWeek.value != daysToGoback) {
                        daysToGoback = range + input.value - closestDayOfWeek.value;
                    }
                } else {
                    daysToGoback = input.value - closestDayOfWeek.value;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Need to go back [" + daysToGoback + "] days to match dayOfWeek");
                }
                ret = (GregorianCalendar)current.clone();
                ret.set(12, closestMinute.value);
                ret.set(11, closestHour.value);
                ((Calendar)ret).add(5, 0 - daysToGoback);
                ret.set(13, 0);
                ret.set(14, 0);
                ret.getTime();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Best guess using DAY_OF_WEEK:[" + ret.getTime() + "]");
                }
            }
            return ret;
        }

        private int getMaximumValForPreviousMonth(Calendar current) {
            Calendar cal = (Calendar)current.clone();
            cal.add(2, -1);
            cal.getTime();
            return cal.getActualMaximum(5);
        }

        private Calendar getEarlierCalendar(Calendar dayOfMonthCalendar, Calendar dayOfWeekCalendar) throws Exception {
            Calendar withDayOfMonth = this.fillOutCalendar(dayOfMonthCalendar);
            if (LOG.isDebugEnabled()) {
                LOG.debug("dayOfMonthCalendar:[" + (withDayOfMonth != null ? withDayOfMonth.getTime() : null) + "]");
            }
            Calendar withDayOfWeek = this.fillOutCalendar(dayOfWeekCalendar);
            if (LOG.isDebugEnabled()) {
                LOG.debug("dayOfWeekCalendar:[" + (withDayOfWeek != null ? withDayOfWeek.getTime() : null) + "]");
            }
            if (withDayOfMonth != null && withDayOfWeek != null) {
                return withDayOfMonth.after(withDayOfWeek) ? withDayOfMonth : withDayOfWeek;
            }
            if (withDayOfMonth == null) {
                return withDayOfWeek;
            }
            return withDayOfMonth;
        }

        private Calendar fillOutCalendar(Calendar calendar) throws Exception {
            Calendar ret = null;
            if (calendar != null) {
                ValueWithBorrow input = new ValueWithBorrow(calendar.get(2));
                ValueWithBorrow closestMonth = this.getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.month, this.months, input);
                input.setValue(calendar.get(1));
                input.setBorrow(closestMonth.borrow);
                ValueWithBorrow closestYear = this.getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec.year, this.years, input);
                ret = (Calendar)calendar.clone();
                ret.set(1, closestYear.value);
                ret.set(2, closestMonth.value);
                ret.set(13, 0);
                ret.getTime();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled-out-Calendar:[" + ret.getTime() + "]");
                }
            }
            return ret;
        }

        private ValueWithBorrow getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec fieldSpec, List<ScheduledTimeMatcher> searchList, ValueWithBorrow input) throws Exception {
            return this.getPastFieldValueWithBorrow(fieldSpec, searchList, input, fieldSpec.maximum);
        }

        private ValueWithBorrow getPastFieldValueWithBorrow(RangerValidityRecurrence.RecurrenceSchedule.ScheduleFieldSpec fieldSpec, List<ScheduledTimeMatcher> searchList, ValueWithBorrow input, int maximum) throws Exception {
            boolean borrow = false;
            int value = input.value - (input.borrow ? 1 : 0);
            if (CollectionUtils.isNotEmpty(searchList)) {
                int range = fieldSpec.maximum - fieldSpec.minimum + 1;
                int i = 0;
                while (i < range) {
                    if (value < fieldSpec.minimum) {
                        value = maximum;
                        borrow = true;
                    }
                    for (ScheduledTimeMatcher time : searchList) {
                        if (!time.isMatch(value)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found match in field:[" + (Object)((Object)fieldSpec) + "], value:[" + value + "], borrow:[" + borrow + "], maximum:[" + maximum + "]");
                        }
                        return new ValueWithBorrow(value, borrow);
                    }
                    ++i;
                    --value;
                }
                throw new Exception("No match found in field:[" + (Object)((Object)fieldSpec) + "] for [input=" + input + "]");
            }
            if (value < fieldSpec.minimum) {
                value = maximum;
            }
            ValueWithBorrow ret = new ValueWithBorrow(value, false);
            return ret;
        }

        private static class ValueWithBorrow {
            int value;
            boolean borrow;

            ValueWithBorrow() {
            }

            ValueWithBorrow(int value) {
                this(value, false);
            }

            ValueWithBorrow(int value, boolean borrow) {
                this.value = value;
                this.borrow = borrow;
            }

            void setValue(int value) {
                this.value = value;
            }

            void setBorrow(boolean borrow) {
                this.borrow = borrow;
            }

            int getValue() {
                return this.value;
            }

            boolean getBorrow() {
                return this.borrow;
            }

            public String toString() {
                return "value=" + this.value + ", borrow=" + this.borrow;
            }
        }
    }
}

