/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerChainedPluginConfig
extends RangerPluginConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RangerChainedPluginConfig.class);
    private final String[] legacySSLProperties = new String[]{"xasecure.policymgr.clientssl.keystore", "xasecure.policymgr.clientssl.keystore.type", "xasecure.policymgr.clientssl.keystore.credential.file", "xasecure.policymgr.clientssl.truststore", "xasecure.policymgr.clientssl.truststore.credential.file", "hadoop.security.credential.provider.path"};
    private final String[] chainedPluginPropertyPrefixes = new String[]{".chained.services"};

    public RangerChainedPluginConfig(String serviceType, String serviceName, String appId, RangerPluginConfig sourcePluginConfig) {
        super(serviceType, serviceName, appId, sourcePluginConfig);
        this.copyProperties(sourcePluginConfig, sourcePluginConfig.getPropertyPrefix());
        this.copyLegacySSLProperties(sourcePluginConfig);
        this.copyProperties(sourcePluginConfig, this.getPropertyPrefix());
        this.copyChainedProperties(sourcePluginConfig, this.getPropertyPrefix());
        this.set(this.getPropertyPrefix() + ".service.name", serviceName);
    }

    private void copyProperties(RangerPluginConfig sourcePluginConfig, String propertyPrefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> copyProperties: propertyPrefix:[" + propertyPrefix + "]");
        }
        for (String propName : sourcePluginConfig.getProperties().stringPropertyNames()) {
            String value = sourcePluginConfig.get(propName);
            if (value == null || !propName.startsWith(propertyPrefix)) continue;
            String suffix = propName.substring(propertyPrefix.length());
            if (!this.isExcludedSuffix(suffix)) {
                this.set(this.getPropertyPrefix() + suffix, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("set property:[" + this.getPropertyPrefix() + suffix + "] to value:[" + value + "]");
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Not copying property :[" + propName + "] value from sourcePluginConfig");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== copyProperties: propertyPrefix:[" + propertyPrefix + "]");
        }
    }

    private void copyLegacySSLProperties(RangerPluginConfig sourcePluginConfig) {
        for (String legacyPropertyName : this.legacySSLProperties) {
            String value = sourcePluginConfig.get(legacyPropertyName);
            if (value == null) continue;
            this.set(legacyPropertyName, value);
        }
    }

    private void copyChainedProperties(RangerPluginConfig sourcePluginConfig, String propertyPrefix) {
        for (String propName : sourcePluginConfig.getProperties().stringPropertyNames()) {
            String value = sourcePluginConfig.get(propName);
            if (value == null || !propName.startsWith(propertyPrefix)) continue;
            String suffix = propName.substring(propertyPrefix.length());
            for (String chainedPropertyPrefix : this.chainedPluginPropertyPrefixes) {
                if (!StringUtils.startsWith((CharSequence)suffix, (CharSequence)chainedPropertyPrefix)) continue;
                this.set(this.getPropertyPrefix() + suffix, value);
            }
        }
    }

    private boolean isExcludedSuffix(String suffix) {
        for (String excludedSuffix : this.chainedPluginPropertyPrefixes) {
            if (!StringUtils.startsWith((CharSequence)suffix, (CharSequence)excludedSuffix)) continue;
            return true;
        }
        return false;
    }

    private String printProperties() {
        StringBuilder sb = new StringBuilder();
        boolean seenOneProp = false;
        for (String propName : this.getProperties().stringPropertyNames()) {
            String value = this.get(propName);
            if (!seenOneProp) {
                seenOneProp = true;
            } else {
                sb.append(",\n");
            }
            sb.append("{ propertyName:[").append(propName).append("], propertyValue:[").append(value).append("] }");
        }
        return sb.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " : { " + this.printProperties() + " }";
    }
}

