#!/bin/bash

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

RETRY_COUNT="${KEYTAB_RETRY_COUNT:-5}"
KEYTABS_DIR=/etc/keytabs

KEYTAB=${KEYTABS_DIR}/$1

for i in {1..RETRY_COUNT}; do
  if [ -f ${KEYTAB} ]
  then
    break
  else
    echo [INFO] "Waiting for keytab ${KEYTAB}.."
    sleep 5
  fi
done

if [ -f ${KEYTAB} ]
then
  echo "[INFO] Found keytab ${KEYTAB}"
  exit 0
else
  echo "[ERROR] Keytab not found: ${KEYTAB}"
  exit 1
fi
