/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.StreamDelivery;
import org.apache.qpid.protonj2.client.StreamReceiver;
import org.apache.qpid.protonj2.client.StreamReceiverOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientReceiverBuilder;
import org.apache.qpid.protonj2.client.impl.ClientReceiverLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientStreamDelivery;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.engine.Receiver;
import org.apache.qpid.protonj2.types.messaging.Released;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientStreamReceiver
extends ClientReceiverLinkType<StreamReceiver>
implements StreamReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ClientFuture<StreamReceiver> drainingFuture;
    private Future<?> drainingTimeout;
    private final StreamReceiverOptions options;
    private final Map<ClientFuture<StreamDelivery>, Future<?>> receiveRequests = new LinkedHashMap();

    ClientStreamReceiver(ClientSession session, StreamReceiverOptions options, String receiverId, Receiver receiver) {
        super(session, receiverId, options, receiver);
        this.options = options;
        if (options.creditWindow() > 0) {
            this.protonReceiver.addCredit(options.creditWindow());
        }
    }

    @Override
    public StreamDelivery receive() throws ClientException {
        return this.receive(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public StreamDelivery receive(long timeout, TimeUnit unit) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture receive = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(receive)) {
                IncomingDelivery delivery = null;
                for (IncomingDelivery unsettled : this.protonReceiver.unsettled()) {
                    if (unsettled.getLinkedResource() != null) continue;
                    delivery = unsettled;
                    break;
                }
                if (delivery == null) {
                    if (timeout == 0L) {
                        receive.complete(null);
                    } else {
                        Future timeoutFuture = timeout > 0L ? this.session.getScheduler().schedule(() -> {
                            this.receiveRequests.remove(receive);
                            receive.complete(null);
                        }, timeout, unit) : null;
                        this.receiveRequests.put(receive, timeoutFuture);
                    }
                } else {
                    receive.complete(new ClientStreamDelivery(this, delivery));
                    if (this.options.creditWindow() > 0) {
                        this.executor.execute(() -> this.replenishCreditIfNeeded());
                    }
                }
            }
        });
        return (StreamDelivery)this.session.request(this, receive);
    }

    @Override
    public StreamDelivery tryReceive() throws ClientException {
        this.checkClosedOrFailed();
        return this.receive(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public StreamReceiver addCredit(int credits) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture creditAdded = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(creditAdded)) {
                if (this.options.creditWindow() != 0) {
                    creditAdded.failed(new ClientIllegalStateException("Cannot add credit when a credit window has been configured"));
                } else if (this.protonReceiver.isDraining()) {
                    creditAdded.failed(new ClientIllegalStateException("Cannot add credit while a drain is pending"));
                } else {
                    try {
                        this.protonReceiver.addCredit(credits);
                        creditAdded.complete(this);
                    }
                    catch (Exception ex) {
                        creditAdded.failed(ClientExceptionSupport.createNonFatalOrPassthrough(ex));
                    }
                }
            }
        });
        return (StreamReceiver)this.session.request(this, creditAdded);
    }

    @Override
    public Future<StreamReceiver> drain() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<StreamReceiver> drainComplete = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(drainComplete)) {
                if (this.protonReceiver.isDraining()) {
                    drainComplete.failed(new ClientIllegalStateException("StreamReceiver is already draining"));
                    return;
                }
                try {
                    if (this.protonReceiver.drain()) {
                        this.drainingFuture = drainComplete;
                        this.drainingTimeout = this.session.scheduleRequestTimeout(this.drainingFuture, this.options.drainTimeout(), () -> new ClientOperationTimedOutException("Timed out waiting for remote to respond to drain request"));
                    } else {
                        drainComplete.complete(this);
                    }
                }
                catch (Exception ex) {
                    drainComplete.failed(ClientExceptionSupport.createNonFatalOrPassthrough(ex));
                }
            }
        });
        return drainComplete;
    }

    @Override
    public long queuedDeliveries() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture request = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(request)) {
                request.complete((int)this.protonReceiver.unsettled().stream().filter(delivery -> delivery.getLinkedResource() == null).count());
            }
        });
        return ((Integer)this.session.request(this, request)).intValue();
    }

    StreamReceiverOptions receiverOptions() {
        return this.options;
    }

    @Override
    protected StreamReceiver self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleDeliveryRead(IncomingDelivery delivery) {
        LOG.trace("Delivery data was received: {}", (Object)delivery);
        if (delivery.getDefaultDeliveryState() == null) {
            delivery.setDefaultDeliveryState((DeliveryState)Released.getInstance());
        }
        if (delivery.getLinkedResource() == null && !this.receiveRequests.isEmpty()) {
            Iterator<Map.Entry<ClientFuture<StreamDelivery>, Future<?>>> entries = this.receiveRequests.entrySet().iterator();
            Map.Entry<ClientFuture<StreamDelivery>, Future<?>> entry = entries.next();
            if (entry.getValue() != null) {
                entry.getValue().cancel(false);
            }
            try {
                entry.getKey().complete(new ClientStreamDelivery(this, delivery));
            }
            finally {
                entries.remove();
                if (this.options.creditWindow() > 0) {
                    this.executor.execute(() -> this.replenishCreditIfNeeded());
                }
            }
        }
    }

    @Override
    protected void replenishCreditIfNeeded() {
        int potentialPrefetch;
        int currentCredit;
        int creditWindow = this.options.creditWindow();
        if (creditWindow > 0 && (double)(currentCredit = this.protonReceiver.getCredit()) <= (double)creditWindow * 0.5 && (double)(potentialPrefetch = currentCredit + (int)this.protonReceiver.unsettled().stream().filter(delivery -> delivery.getLinkedResource() == null).count()) <= (double)creditWindow * 0.7) {
            int additionalCredit = creditWindow - potentialPrefetch;
            LOG.trace("Consumer granting additional credit: {}", (Object)additionalCredit);
            try {
                this.protonReceiver.addCredit(additionalCredit);
            }
            catch (Exception ex) {
                LOG.debug("Error caught during credit top-up", (Throwable)ex);
            }
        }
    }

    @Override
    protected void linkSpecificCleanupHandler(ClientException failureCause) {
        this.session.closeAsync();
        this.receiveRequests.forEach((future, timeout) -> {
            if (timeout != null) {
                timeout.cancel(false);
            }
            if (failureCause != null) {
                future.failed(failureCause);
            } else {
                future.failed(new ClientResourceRemotelyClosedException("The Stream Receiver has closed"));
            }
        });
        this.protonReceiver.unsettled().forEach(delivery -> {
            if (delivery.getLinkedResource() != null) {
                try {
                    ((ClientStreamDelivery)delivery.getLinkedResource(ClientStreamDelivery.class)).handleReceiverClosed(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        super.linkSpecificCleanupHandler(failureCause);
    }

    @Override
    protected void recreateLinkForReconnect() {
        int previousCredit = this.protonReceiver.getCredit() + this.protonReceiver.unsettled().size();
        if (this.drainingFuture != null) {
            this.drainingFuture.complete(this);
            if (this.drainingTimeout != null) {
                this.drainingTimeout.cancel(false);
                this.drainingTimeout = null;
            }
        }
        this.protonReceiver.localCloseHandler(null);
        this.protonReceiver.localDetachHandler(null);
        this.protonReceiver.close();
        this.protonReceiver = ClientReceiverBuilder.recreateReceiver(this.session, this.protonReceiver, this.options);
        this.protonReceiver.setLinkedResource((Object)this);
        this.protonReceiver.addCredit(previousCredit);
    }
}

