/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const http = require('http');

const request = (url, { headers, data = {}, method }) => new Promise((resolve, reject) => {
  const req = http.request(url, {
    headers,
    method,
  }, (res) => {
    let responseBody = '';
    res.on('data', (chunk) => {
      responseBody += chunk;
    });
    res.on('end', () => {
      resolve({ responseBody, statusCode: res.statusCode });
    });
  });

  req.on('error', (error) => {
    reject(error);
  });

  req.write(JSON.stringify(data));

  req.end();
});

function createPartitionedTopic(topic, numPartitions) {
  const url = `http://localhost:8080/admin/v2/persistent/public/default/${topic}/partitions`;
  return request(url, {
    headers: {
      'Content-Type': 'application/json',
    },
    data: numPartitions,
    method: 'PUT',
  });
}

module.exports = {
  createPartitionedTopic,
  request,
};
