/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LldpTlvType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 18957;
  }

  // Properties.
  protected final long tlvType;
  protected final PascalByteString tlvInfo;

  public LldpTlvType(long tlvType, PascalByteString tlvInfo) {
    super();
    this.tlvType = tlvType;
    this.tlvInfo = tlvInfo;
  }

  public long getTlvType() {
    return tlvType;
  }

  public PascalByteString getTlvInfo() {
    return tlvInfo;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LldpTlvType");

    // Simple Field (tlvType)
    writeSimpleField("tlvType", tlvType, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (tlvInfo)
    writeSimpleField("tlvInfo", tlvInfo, writeComplex(writeBuffer));

    writeBuffer.popContext("LldpTlvType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LldpTlvType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (tlvType)
    lengthInBits += 32;

    // Simple field (tlvInfo)
    lengthInBits += tlvInfo.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("LldpTlvType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long tlvType = readSimpleField("tlvType", readUnsignedLong(readBuffer, 32));

    PascalByteString tlvInfo =
        readSimpleField(
            "tlvInfo", readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("LldpTlvType");
    // Create the instance
    return new LldpTlvTypeBuilderImpl(tlvType, tlvInfo);
  }

  public static class LldpTlvTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long tlvType;
    private final PascalByteString tlvInfo;

    public LldpTlvTypeBuilderImpl(long tlvType, PascalByteString tlvInfo) {
      this.tlvType = tlvType;
      this.tlvInfo = tlvInfo;
    }

    public LldpTlvType build() {
      LldpTlvType lldpTlvType = new LldpTlvType(tlvType, tlvInfo);
      return lldpTlvType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LldpTlvType)) {
      return false;
    }
    LldpTlvType that = (LldpTlvType) o;
    return (getTlvType() == that.getTlvType())
        && (getTlvInfo() == that.getTlvInfo())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTlvType(), getTlvInfo());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
