/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonNetworkMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19313;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final PascalString writerGroupName;
  protected final PascalString dataSetClassId;
  protected final List<ExtensionObject> messages;

  public JsonNetworkMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      PascalString writerGroupName,
      PascalString dataSetClassId,
      List<ExtensionObject> messages) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.writerGroupName = writerGroupName;
    this.dataSetClassId = dataSetClassId;
    this.messages = messages;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public PascalString getWriterGroupName() {
    return writerGroupName;
  }

  public PascalString getDataSetClassId() {
    return dataSetClassId;
  }

  public List<ExtensionObject> getMessages() {
    return messages;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonNetworkMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (writerGroupName)
    writeSimpleField("writerGroupName", writerGroupName, writeComplex(writeBuffer));

    // Simple Field (dataSetClassId)
    writeSimpleField("dataSetClassId", dataSetClassId, writeComplex(writeBuffer));

    // Implicit Field (noOfMessages) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfMessages = (int) ((((getMessages()) == (null)) ? -(1) : COUNT(getMessages())));
    writeImplicitField("noOfMessages", noOfMessages, writeSignedInt(writeBuffer, 32));

    // Array Field (messages)
    writeComplexTypeArrayField("messages", messages, writeBuffer);

    writeBuffer.popContext("JsonNetworkMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonNetworkMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (writerGroupName)
    lengthInBits += writerGroupName.getLengthInBits();

    // Simple field (dataSetClassId)
    lengthInBits += dataSetClassId.getLengthInBits();

    // Implicit Field (noOfMessages)
    lengthInBits += 32;

    // Array field
    if (messages != null) {
      int i = 0;
      for (ExtensionObject element : messages) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= messages.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonNetworkMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString writerGroupName =
        readSimpleField(
            "writerGroupName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString dataSetClassId =
        readSimpleField(
            "dataSetClassId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfMessages = readImplicitField("noOfMessages", readSignedInt(readBuffer, 32));

    List<ExtensionObject> messages =
        readCountArrayField(
            "messages",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer),
            noOfMessages);

    readBuffer.closeContext("JsonNetworkMessage");
    // Create the instance
    return new JsonNetworkMessageBuilderImpl(
        messageId, messageType, publisherId, writerGroupName, dataSetClassId, messages);
  }

  public static class JsonNetworkMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final PascalString writerGroupName;
    private final PascalString dataSetClassId;
    private final List<ExtensionObject> messages;

    public JsonNetworkMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        PascalString writerGroupName,
        PascalString dataSetClassId,
        List<ExtensionObject> messages) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.writerGroupName = writerGroupName;
      this.dataSetClassId = dataSetClassId;
      this.messages = messages;
    }

    public JsonNetworkMessage build() {
      JsonNetworkMessage jsonNetworkMessage =
          new JsonNetworkMessage(
              messageId, messageType, publisherId, writerGroupName, dataSetClassId, messages);
      return jsonNetworkMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonNetworkMessage)) {
      return false;
    }
    JsonNetworkMessage that = (JsonNetworkMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getWriterGroupName() == that.getWriterGroupName())
        && (getDataSetClassId() == that.getDataSetClassId())
        && (getMessages() == that.getMessages())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getWriterGroupName(),
        getDataSetClassId(),
        getMessages());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
