/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BrowseResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 524;
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final PascalByteString continuationPoint;
  protected final List<ReferenceDescription> references;

  public BrowseResult(
      StatusCode statusCode,
      PascalByteString continuationPoint,
      List<ReferenceDescription> references) {
    super();
    this.statusCode = statusCode;
    this.continuationPoint = continuationPoint;
    this.references = references;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public PascalByteString getContinuationPoint() {
    return continuationPoint;
  }

  public List<ReferenceDescription> getReferences() {
    return references;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BrowseResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, writeComplex(writeBuffer));

    // Simple Field (continuationPoint)
    writeSimpleField("continuationPoint", continuationPoint, writeComplex(writeBuffer));

    // Implicit Field (noOfReferences) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfReferences = (int) ((((getReferences()) == (null)) ? -(1) : COUNT(getReferences())));
    writeImplicitField("noOfReferences", noOfReferences, writeSignedInt(writeBuffer, 32));

    // Array Field (references)
    writeComplexTypeArrayField("references", references, writeBuffer);

    writeBuffer.popContext("BrowseResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BrowseResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Simple field (continuationPoint)
    lengthInBits += continuationPoint.getLengthInBits();

    // Implicit Field (noOfReferences)
    lengthInBits += 32;

    // Array field
    if (references != null) {
      int i = 0;
      for (ReferenceDescription element : references) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= references.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("BrowseResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    StatusCode statusCode =
        readSimpleField(
            "statusCode", readComplex(() -> StatusCode.staticParse(readBuffer), readBuffer));

    PascalByteString continuationPoint =
        readSimpleField(
            "continuationPoint",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer));

    int noOfReferences = readImplicitField("noOfReferences", readSignedInt(readBuffer, 32));

    List<ReferenceDescription> references =
        readCountArrayField(
            "references",
            readComplex(
                () ->
                    (ReferenceDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (520)),
                readBuffer),
            noOfReferences);

    readBuffer.closeContext("BrowseResult");
    // Create the instance
    return new BrowseResultBuilderImpl(statusCode, continuationPoint, references);
  }

  public static class BrowseResultBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final PascalByteString continuationPoint;
    private final List<ReferenceDescription> references;

    public BrowseResultBuilderImpl(
        StatusCode statusCode,
        PascalByteString continuationPoint,
        List<ReferenceDescription> references) {
      this.statusCode = statusCode;
      this.continuationPoint = continuationPoint;
      this.references = references;
    }

    public BrowseResult build() {
      BrowseResult browseResult = new BrowseResult(statusCode, continuationPoint, references);
      return browseResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BrowseResult)) {
      return false;
    }
    BrowseResult that = (BrowseResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getContinuationPoint() == that.getContinuationPoint())
        && (getReferences() == that.getReferences())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getStatusCode(), getContinuationPoint(), getReferences());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
