/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ActivateSessionRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 467;
  }

  // Properties.
  protected final RequestHeader requestHeader;
  protected final SignatureData clientSignature;
  protected final List<SignedSoftwareCertificate> clientSoftwareCertificates;
  protected final List<PascalString> localeIds;
  protected final ExtensionObject userIdentityToken;
  protected final SignatureData userTokenSignature;

  public ActivateSessionRequest(
      RequestHeader requestHeader,
      SignatureData clientSignature,
      List<SignedSoftwareCertificate> clientSoftwareCertificates,
      List<PascalString> localeIds,
      ExtensionObject userIdentityToken,
      SignatureData userTokenSignature) {
    super();
    this.requestHeader = requestHeader;
    this.clientSignature = clientSignature;
    this.clientSoftwareCertificates = clientSoftwareCertificates;
    this.localeIds = localeIds;
    this.userIdentityToken = userIdentityToken;
    this.userTokenSignature = userTokenSignature;
  }

  public RequestHeader getRequestHeader() {
    return requestHeader;
  }

  public SignatureData getClientSignature() {
    return clientSignature;
  }

  public List<SignedSoftwareCertificate> getClientSoftwareCertificates() {
    return clientSoftwareCertificates;
  }

  public List<PascalString> getLocaleIds() {
    return localeIds;
  }

  public ExtensionObject getUserIdentityToken() {
    return userIdentityToken;
  }

  public SignatureData getUserTokenSignature() {
    return userTokenSignature;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ActivateSessionRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, writeComplex(writeBuffer));

    // Simple Field (clientSignature)
    writeSimpleField("clientSignature", clientSignature, writeComplex(writeBuffer));

    // Implicit Field (noOfClientSoftwareCertificates) (Used for parsing, but its value is not
    // stored as it's implicitly given by the objects content)
    int noOfClientSoftwareCertificates =
        (int)
            ((((getClientSoftwareCertificates()) == (null))
                ? -(1)
                : COUNT(getClientSoftwareCertificates())));
    writeImplicitField(
        "noOfClientSoftwareCertificates",
        noOfClientSoftwareCertificates,
        writeSignedInt(writeBuffer, 32));

    // Array Field (clientSoftwareCertificates)
    writeComplexTypeArrayField(
        "clientSoftwareCertificates", clientSoftwareCertificates, writeBuffer);

    // Implicit Field (noOfLocaleIds) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfLocaleIds = (int) ((((getLocaleIds()) == (null)) ? -(1) : COUNT(getLocaleIds())));
    writeImplicitField("noOfLocaleIds", noOfLocaleIds, writeSignedInt(writeBuffer, 32));

    // Array Field (localeIds)
    writeComplexTypeArrayField("localeIds", localeIds, writeBuffer);

    // Simple Field (userIdentityToken)
    writeSimpleField("userIdentityToken", userIdentityToken, writeComplex(writeBuffer));

    // Simple Field (userTokenSignature)
    writeSimpleField("userTokenSignature", userTokenSignature, writeComplex(writeBuffer));

    writeBuffer.popContext("ActivateSessionRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ActivateSessionRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (clientSignature)
    lengthInBits += clientSignature.getLengthInBits();

    // Implicit Field (noOfClientSoftwareCertificates)
    lengthInBits += 32;

    // Array field
    if (clientSoftwareCertificates != null) {
      int i = 0;
      for (SignedSoftwareCertificate element : clientSoftwareCertificates) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= clientSoftwareCertificates.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfLocaleIds)
    lengthInBits += 32;

    // Array field
    if (localeIds != null) {
      int i = 0;
      for (PascalString element : localeIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= localeIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (userIdentityToken)
    lengthInBits += userIdentityToken.getLengthInBits();

    // Simple field (userTokenSignature)
    lengthInBits += userTokenSignature.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ActivateSessionRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestHeader requestHeader =
        readSimpleField(
            "requestHeader",
            readComplex(
                () ->
                    (RequestHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (391)),
                readBuffer));

    SignatureData clientSignature =
        readSimpleField(
            "clientSignature",
            readComplex(
                () ->
                    (SignatureData) ExtensionObjectDefinition.staticParse(readBuffer, (int) (458)),
                readBuffer));

    int noOfClientSoftwareCertificates =
        readImplicitField("noOfClientSoftwareCertificates", readSignedInt(readBuffer, 32));

    List<SignedSoftwareCertificate> clientSoftwareCertificates =
        readCountArrayField(
            "clientSoftwareCertificates",
            readComplex(
                () ->
                    (SignedSoftwareCertificate)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (346)),
                readBuffer),
            noOfClientSoftwareCertificates);

    int noOfLocaleIds = readImplicitField("noOfLocaleIds", readSignedInt(readBuffer, 32));

    List<PascalString> localeIds =
        readCountArrayField(
            "localeIds",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfLocaleIds);

    ExtensionObject userIdentityToken =
        readSimpleField(
            "userIdentityToken",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    SignatureData userTokenSignature =
        readSimpleField(
            "userTokenSignature",
            readComplex(
                () ->
                    (SignatureData) ExtensionObjectDefinition.staticParse(readBuffer, (int) (458)),
                readBuffer));

    readBuffer.closeContext("ActivateSessionRequest");
    // Create the instance
    return new ActivateSessionRequestBuilderImpl(
        requestHeader,
        clientSignature,
        clientSoftwareCertificates,
        localeIds,
        userIdentityToken,
        userTokenSignature);
  }

  public static class ActivateSessionRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final RequestHeader requestHeader;
    private final SignatureData clientSignature;
    private final List<SignedSoftwareCertificate> clientSoftwareCertificates;
    private final List<PascalString> localeIds;
    private final ExtensionObject userIdentityToken;
    private final SignatureData userTokenSignature;

    public ActivateSessionRequestBuilderImpl(
        RequestHeader requestHeader,
        SignatureData clientSignature,
        List<SignedSoftwareCertificate> clientSoftwareCertificates,
        List<PascalString> localeIds,
        ExtensionObject userIdentityToken,
        SignatureData userTokenSignature) {
      this.requestHeader = requestHeader;
      this.clientSignature = clientSignature;
      this.clientSoftwareCertificates = clientSoftwareCertificates;
      this.localeIds = localeIds;
      this.userIdentityToken = userIdentityToken;
      this.userTokenSignature = userTokenSignature;
    }

    public ActivateSessionRequest build() {
      ActivateSessionRequest activateSessionRequest =
          new ActivateSessionRequest(
              requestHeader,
              clientSignature,
              clientSoftwareCertificates,
              localeIds,
              userIdentityToken,
              userTokenSignature);
      return activateSessionRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ActivateSessionRequest)) {
      return false;
    }
    ActivateSessionRequest that = (ActivateSessionRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getClientSignature() == that.getClientSignature())
        && (getClientSoftwareCertificates() == that.getClientSoftwareCertificates())
        && (getLocaleIds() == that.getLocaleIds())
        && (getUserIdentityToken() == that.getUserIdentityToken())
        && (getUserTokenSignature() == that.getUserTokenSignature())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getClientSignature(),
        getClientSoftwareCertificates(),
        getLocaleIds(),
        getUserIdentityToken(),
        getUserTokenSignature());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
