/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum CauseOfTransmission {
  PERIODIC_CYCLIC_PER_CYC((byte) 0x01),
  BACKGROUND_INTERROGATION_BACK((byte) 0x02),
  SPONTANEOUS_SPONT((byte) 0x03),
  INITIALIZED_INIT((byte) 0x04),
  INTERROGATION_OR_INTERROGATED_REQ((byte) 0x05),
  ACTIVATION_ACT((byte) 0x06),
  CONFIRMATION_ACTIVATION_ACTCON((byte) 0x07),
  DEACTIVATION_DEACT((byte) 0x08),
  CONFIRMATION_DEACTIVATION_DEACTCON((byte) 0x09),
  TERMINATION_ACTIVATION_ACTTERM((byte) 0x0A),
  FEEDBACK_CAUSED_BY_DISTANT_COMMAND_RETREM((byte) 0x0B),
  FEEDBACK_CAUSED_BY_LOCAL_COMMAND_RETLOC((byte) 0x0C),
  DATA_TRANSMISSION_FILE((byte) 0x0D),
  INTERROGATED_BY_GENERAL_INTERROGATION_INROGEN((byte) 0x14),
  INTERROGATED_BY_INTERROGATION_GROUP_1_INRO1((byte) 0x15),
  INTERROGATED_BY_INTERROGATION_GROUP_2_INRO2((byte) 0x16),
  INTERROGATED_BY_INTERROGATION_GROUP_3_INRO3((byte) 0x17),
  INTERROGATED_BY_INTERROGATION_GROUP_4_INRO4((byte) 0x18),
  INTERROGATED_BY_INTERROGATION_GROUP_5_INRO5((byte) 0x19),
  INTERROGATED_BY_INTERROGATION_GROUP_6_INRO6((byte) 0x1A),
  INTERROGATED_BY_INTERROGATION_GROUP_7_INRO7((byte) 0x1B),
  INTERROGATED_BY_INTERROGATION_GROUP_8_INRO8((byte) 0x1C),
  INTERROGATED_BY_INTERROGATION_GROUP_9_INRO9((byte) 0x1D),
  INTERROGATED_BY_INTERROGATION_GROUP_10_INRO10((byte) 0x1E),
  INTERROGATED_BY_INTERROGATION_GROUP_11_INRO11((byte) 0x1F),
  INTERROGATED_BY_INTERROGATION_GROUP_12_INRO12((byte) 0x20),
  INTERROGATED_BY_INTERROGATION_GROUP_13_INRO13((byte) 0x21),
  INTERROGATED_BY_INTERROGATION_GROUP_14_INRO14((byte) 0x22),
  INTERROGATED_BY_INTERROGATION_GROUP_15_INRO15((byte) 0x23),
  INTERROGATED_BY_INTERROGATION_GROUP_16_INRO16((byte) 0x24),
  INTERROGATED_BY_COUNTER_GENERAL_INTERROGATION_REQCOGEN((byte) 0x25),
  INTERROGATED_BY_INTERROGATION_COUNTER_GROUP_1_REQCO1((byte) 0x26),
  INTERROGATED_BY_INTERROGATION_COUNTER_GROUP_2_REQCO2((byte) 0x27),
  INTERROGATED_BY_INTERROGATION_COUNTER_GROUP_3_REQCO3((byte) 0x28),
  INTERROGATED_BY_INTERROGATION_COUNTER_GROUP_4_REQCO4((byte) 0x29),
  TYPE_IDENTIFICATION_UNKNOWN_UKNOWN_TYPE((byte) 0x2C),
  CAUSE_UNKNOWN_UKNOWN_CAUSE((byte) 0x2D),
  ASDU_ADDRESS_UNKNOWN_UNKNOWN_ASDU_ADDRESS((byte) 0x2E),
  INFORMATION_OBJECT_ADDRESS_UNKNOWN_UNKNOWN_OBJECT_ADDRESS((byte) 0x2F);
  private static final Map<Byte, CauseOfTransmission> map;

  static {
    map = new HashMap<>();
    for (CauseOfTransmission value : CauseOfTransmission.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;

  CauseOfTransmission(byte value) {
    this.value = value;
  }

  public byte getValue() {
    return value;
  }

  public static CauseOfTransmission enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
