/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetEventSummary implements Message {

  // Properties.
  protected final BACnetContextTagObjectIdentifier objectIdentifier;
  protected final BACnetEventStateTagged eventState;
  protected final BACnetEventTransitionBitsTagged acknowledgedTransitions;
  protected final BACnetEventTimestampsEnclosed eventTimestamps;
  protected final BACnetNotifyTypeTagged notifyType;
  protected final BACnetEventTransitionBitsTagged eventEnable;
  protected final BACnetEventPriorities eventPriorities;

  public BACnetEventSummary(
      BACnetContextTagObjectIdentifier objectIdentifier,
      BACnetEventStateTagged eventState,
      BACnetEventTransitionBitsTagged acknowledgedTransitions,
      BACnetEventTimestampsEnclosed eventTimestamps,
      BACnetNotifyTypeTagged notifyType,
      BACnetEventTransitionBitsTagged eventEnable,
      BACnetEventPriorities eventPriorities) {
    super();
    this.objectIdentifier = objectIdentifier;
    this.eventState = eventState;
    this.acknowledgedTransitions = acknowledgedTransitions;
    this.eventTimestamps = eventTimestamps;
    this.notifyType = notifyType;
    this.eventEnable = eventEnable;
    this.eventPriorities = eventPriorities;
  }

  public BACnetContextTagObjectIdentifier getObjectIdentifier() {
    return objectIdentifier;
  }

  public BACnetEventStateTagged getEventState() {
    return eventState;
  }

  public BACnetEventTransitionBitsTagged getAcknowledgedTransitions() {
    return acknowledgedTransitions;
  }

  public BACnetEventTimestampsEnclosed getEventTimestamps() {
    return eventTimestamps;
  }

  public BACnetNotifyTypeTagged getNotifyType() {
    return notifyType;
  }

  public BACnetEventTransitionBitsTagged getEventEnable() {
    return eventEnable;
  }

  public BACnetEventPriorities getEventPriorities() {
    return eventPriorities;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetEventSummary");

    // Simple Field (objectIdentifier)
    writeSimpleField("objectIdentifier", objectIdentifier, writeComplex(writeBuffer));

    // Simple Field (eventState)
    writeSimpleField("eventState", eventState, writeComplex(writeBuffer));

    // Simple Field (acknowledgedTransitions)
    writeSimpleField("acknowledgedTransitions", acknowledgedTransitions, writeComplex(writeBuffer));

    // Simple Field (eventTimestamps)
    writeSimpleField("eventTimestamps", eventTimestamps, writeComplex(writeBuffer));

    // Simple Field (notifyType)
    writeSimpleField("notifyType", notifyType, writeComplex(writeBuffer));

    // Simple Field (eventEnable)
    writeSimpleField("eventEnable", eventEnable, writeComplex(writeBuffer));

    // Simple Field (eventPriorities)
    writeSimpleField("eventPriorities", eventPriorities, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetEventSummary");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetEventSummary _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (objectIdentifier)
    lengthInBits += objectIdentifier.getLengthInBits();

    // Simple field (eventState)
    lengthInBits += eventState.getLengthInBits();

    // Simple field (acknowledgedTransitions)
    lengthInBits += acknowledgedTransitions.getLengthInBits();

    // Simple field (eventTimestamps)
    lengthInBits += eventTimestamps.getLengthInBits();

    // Simple field (notifyType)
    lengthInBits += notifyType.getLengthInBits();

    // Simple field (eventEnable)
    lengthInBits += eventEnable.getLengthInBits();

    // Simple field (eventPriorities)
    lengthInBits += eventPriorities.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetEventSummary staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetEventSummary");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagObjectIdentifier objectIdentifier =
        readSimpleField(
            "objectIdentifier",
            readComplex(
                () ->
                    (BACnetContextTagObjectIdentifier)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.BACNET_OBJECT_IDENTIFIER)),
                readBuffer));

    BACnetEventStateTagged eventState =
        readSimpleField(
            "eventState",
            readComplex(
                () ->
                    BACnetEventStateTagged.staticParse(
                        readBuffer, (short) (1), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetEventTransitionBitsTagged acknowledgedTransitions =
        readSimpleField(
            "acknowledgedTransitions",
            readComplex(
                () ->
                    BACnetEventTransitionBitsTagged.staticParse(
                        readBuffer, (short) (2), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetEventTimestampsEnclosed eventTimestamps =
        readSimpleField(
            "eventTimestamps",
            readComplex(
                () -> BACnetEventTimestampsEnclosed.staticParse(readBuffer, (short) (3)),
                readBuffer));

    BACnetNotifyTypeTagged notifyType =
        readSimpleField(
            "notifyType",
            readComplex(
                () ->
                    BACnetNotifyTypeTagged.staticParse(
                        readBuffer, (short) (4), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetEventTransitionBitsTagged eventEnable =
        readSimpleField(
            "eventEnable",
            readComplex(
                () ->
                    BACnetEventTransitionBitsTagged.staticParse(
                        readBuffer, (short) (5), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetEventPriorities eventPriorities =
        readSimpleField(
            "eventPriorities",
            readComplex(
                () -> BACnetEventPriorities.staticParse(readBuffer, (short) (6)), readBuffer));

    readBuffer.closeContext("BACnetEventSummary");
    // Create the instance
    BACnetEventSummary _bACnetEventSummary;
    _bACnetEventSummary =
        new BACnetEventSummary(
            objectIdentifier,
            eventState,
            acknowledgedTransitions,
            eventTimestamps,
            notifyType,
            eventEnable,
            eventPriorities);
    return _bACnetEventSummary;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetEventSummary)) {
      return false;
    }
    BACnetEventSummary that = (BACnetEventSummary) o;
    return (getObjectIdentifier() == that.getObjectIdentifier())
        && (getEventState() == that.getEventState())
        && (getAcknowledgedTransitions() == that.getAcknowledgedTransitions())
        && (getEventTimestamps() == that.getEventTimestamps())
        && (getNotifyType() == that.getNotifyType())
        && (getEventEnable() == that.getEventEnable())
        && (getEventPriorities() == that.getEventPriorities())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getObjectIdentifier(),
        getEventState(),
        getAcknowledgedTransitions(),
        getEventTimestamps(),
        getNotifyType(),
        getEventEnable(),
        getEventPriorities());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
