/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariableTypeAttributes is the corresponding interface of VariableTypeAttributes
type VariableTypeAttributes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSpecifiedAttributes returns SpecifiedAttributes (property field)
	GetSpecifiedAttributes() uint32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// GetWriteMask returns WriteMask (property field)
	GetWriteMask() uint32
	// GetUserWriteMask returns UserWriteMask (property field)
	GetUserWriteMask() uint32
	// GetValue returns Value (property field)
	GetValue() Variant
	// GetDataType returns DataType (property field)
	GetDataType() NodeId
	// GetValueRank returns ValueRank (property field)
	GetValueRank() int32
	// GetArrayDimensions returns ArrayDimensions (property field)
	GetArrayDimensions() []uint32
	// GetIsAbstract returns IsAbstract (property field)
	GetIsAbstract() bool
	// IsVariableTypeAttributes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariableTypeAttributes()
	// CreateBuilder creates a VariableTypeAttributesBuilder
	CreateVariableTypeAttributesBuilder() VariableTypeAttributesBuilder
}

// _VariableTypeAttributes is the data-structure of this message
type _VariableTypeAttributes struct {
	ExtensionObjectDefinitionContract
	SpecifiedAttributes uint32
	DisplayName         LocalizedText
	Description         LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	Value               Variant
	DataType            NodeId
	ValueRank           int32
	ArrayDimensions     []uint32
	IsAbstract          bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ VariableTypeAttributes = (*_VariableTypeAttributes)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_VariableTypeAttributes)(nil)

// NewVariableTypeAttributes factory function for _VariableTypeAttributes
func NewVariableTypeAttributes(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, value Variant, dataType NodeId, valueRank int32, arrayDimensions []uint32, isAbstract bool) *_VariableTypeAttributes {
	if displayName == nil {
		panic("displayName of type LocalizedText for VariableTypeAttributes must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for VariableTypeAttributes must not be nil")
	}
	if value == nil {
		panic("value of type Variant for VariableTypeAttributes must not be nil")
	}
	if dataType == nil {
		panic("dataType of type NodeId for VariableTypeAttributes must not be nil")
	}
	_result := &_VariableTypeAttributes{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SpecifiedAttributes:               specifiedAttributes,
		DisplayName:                       displayName,
		Description:                       description,
		WriteMask:                         writeMask,
		UserWriteMask:                     userWriteMask,
		Value:                             value,
		DataType:                          dataType,
		ValueRank:                         valueRank,
		ArrayDimensions:                   arrayDimensions,
		IsAbstract:                        isAbstract,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariableTypeAttributesBuilder is a builder for VariableTypeAttributes
type VariableTypeAttributesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, value Variant, dataType NodeId, valueRank int32, arrayDimensions []uint32, isAbstract bool) VariableTypeAttributesBuilder
	// WithSpecifiedAttributes adds SpecifiedAttributes (property field)
	WithSpecifiedAttributes(uint32) VariableTypeAttributesBuilder
	// WithDisplayName adds DisplayName (property field)
	WithDisplayName(LocalizedText) VariableTypeAttributesBuilder
	// WithDisplayNameBuilder adds DisplayName (property field) which is build by the builder
	WithDisplayNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) VariableTypeAttributesBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) VariableTypeAttributesBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) VariableTypeAttributesBuilder
	// WithWriteMask adds WriteMask (property field)
	WithWriteMask(uint32) VariableTypeAttributesBuilder
	// WithUserWriteMask adds UserWriteMask (property field)
	WithUserWriteMask(uint32) VariableTypeAttributesBuilder
	// WithValue adds Value (property field)
	WithValue(Variant) VariableTypeAttributesBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(VariantBuilder) VariantBuilder) VariableTypeAttributesBuilder
	// WithDataType adds DataType (property field)
	WithDataType(NodeId) VariableTypeAttributesBuilder
	// WithDataTypeBuilder adds DataType (property field) which is build by the builder
	WithDataTypeBuilder(func(NodeIdBuilder) NodeIdBuilder) VariableTypeAttributesBuilder
	// WithValueRank adds ValueRank (property field)
	WithValueRank(int32) VariableTypeAttributesBuilder
	// WithArrayDimensions adds ArrayDimensions (property field)
	WithArrayDimensions(...uint32) VariableTypeAttributesBuilder
	// WithIsAbstract adds IsAbstract (property field)
	WithIsAbstract(bool) VariableTypeAttributesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the VariableTypeAttributes or returns an error if something is wrong
	Build() (VariableTypeAttributes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariableTypeAttributes
}

// NewVariableTypeAttributesBuilder() creates a VariableTypeAttributesBuilder
func NewVariableTypeAttributesBuilder() VariableTypeAttributesBuilder {
	return &_VariableTypeAttributesBuilder{_VariableTypeAttributes: new(_VariableTypeAttributes)}
}

type _VariableTypeAttributesBuilder struct {
	*_VariableTypeAttributes

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (VariableTypeAttributesBuilder) = (*_VariableTypeAttributesBuilder)(nil)

func (b *_VariableTypeAttributesBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._VariableTypeAttributes
}

func (b *_VariableTypeAttributesBuilder) WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, value Variant, dataType NodeId, valueRank int32, arrayDimensions []uint32, isAbstract bool) VariableTypeAttributesBuilder {
	return b.WithSpecifiedAttributes(specifiedAttributes).WithDisplayName(displayName).WithDescription(description).WithWriteMask(writeMask).WithUserWriteMask(userWriteMask).WithValue(value).WithDataType(dataType).WithValueRank(valueRank).WithArrayDimensions(arrayDimensions...).WithIsAbstract(isAbstract)
}

func (b *_VariableTypeAttributesBuilder) WithSpecifiedAttributes(specifiedAttributes uint32) VariableTypeAttributesBuilder {
	b.SpecifiedAttributes = specifiedAttributes
	return b
}

func (b *_VariableTypeAttributesBuilder) WithDisplayName(displayName LocalizedText) VariableTypeAttributesBuilder {
	b.DisplayName = displayName
	return b
}

func (b *_VariableTypeAttributesBuilder) WithDisplayNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) VariableTypeAttributesBuilder {
	builder := builderSupplier(b.DisplayName.CreateLocalizedTextBuilder())
	var err error
	b.DisplayName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_VariableTypeAttributesBuilder) WithDescription(description LocalizedText) VariableTypeAttributesBuilder {
	b.Description = description
	return b
}

func (b *_VariableTypeAttributesBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) VariableTypeAttributesBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_VariableTypeAttributesBuilder) WithWriteMask(writeMask uint32) VariableTypeAttributesBuilder {
	b.WriteMask = writeMask
	return b
}

func (b *_VariableTypeAttributesBuilder) WithUserWriteMask(userWriteMask uint32) VariableTypeAttributesBuilder {
	b.UserWriteMask = userWriteMask
	return b
}

func (b *_VariableTypeAttributesBuilder) WithValue(value Variant) VariableTypeAttributesBuilder {
	b.Value = value
	return b
}

func (b *_VariableTypeAttributesBuilder) WithValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) VariableTypeAttributesBuilder {
	builder := builderSupplier(b.Value.CreateVariantBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_VariableTypeAttributesBuilder) WithDataType(dataType NodeId) VariableTypeAttributesBuilder {
	b.DataType = dataType
	return b
}

func (b *_VariableTypeAttributesBuilder) WithDataTypeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) VariableTypeAttributesBuilder {
	builder := builderSupplier(b.DataType.CreateNodeIdBuilder())
	var err error
	b.DataType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_VariableTypeAttributesBuilder) WithValueRank(valueRank int32) VariableTypeAttributesBuilder {
	b.ValueRank = valueRank
	return b
}

func (b *_VariableTypeAttributesBuilder) WithArrayDimensions(arrayDimensions ...uint32) VariableTypeAttributesBuilder {
	b.ArrayDimensions = arrayDimensions
	return b
}

func (b *_VariableTypeAttributesBuilder) WithIsAbstract(isAbstract bool) VariableTypeAttributesBuilder {
	b.IsAbstract = isAbstract
	return b
}

func (b *_VariableTypeAttributesBuilder) Build() (VariableTypeAttributes, error) {
	if b.DisplayName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'displayName' not set"))
	}
	if b.Description == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'description' not set"))
	}
	if b.Value == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'value' not set"))
	}
	if b.DataType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dataType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._VariableTypeAttributes.deepCopy(), nil
}

func (b *_VariableTypeAttributesBuilder) MustBuild() VariableTypeAttributes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariableTypeAttributesBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_VariableTypeAttributesBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_VariableTypeAttributesBuilder) DeepCopy() any {
	_copy := b.CreateVariableTypeAttributesBuilder().(*_VariableTypeAttributesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateVariableTypeAttributesBuilder creates a VariableTypeAttributesBuilder
func (b *_VariableTypeAttributes) CreateVariableTypeAttributesBuilder() VariableTypeAttributesBuilder {
	if b == nil {
		return NewVariableTypeAttributesBuilder()
	}
	return &_VariableTypeAttributesBuilder{_VariableTypeAttributes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariableTypeAttributes) GetExtensionId() int32 {
	return int32(366)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariableTypeAttributes) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariableTypeAttributes) GetSpecifiedAttributes() uint32 {
	return m.SpecifiedAttributes
}

func (m *_VariableTypeAttributes) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_VariableTypeAttributes) GetDescription() LocalizedText {
	return m.Description
}

func (m *_VariableTypeAttributes) GetWriteMask() uint32 {
	return m.WriteMask
}

func (m *_VariableTypeAttributes) GetUserWriteMask() uint32 {
	return m.UserWriteMask
}

func (m *_VariableTypeAttributes) GetValue() Variant {
	return m.Value
}

func (m *_VariableTypeAttributes) GetDataType() NodeId {
	return m.DataType
}

func (m *_VariableTypeAttributes) GetValueRank() int32 {
	return m.ValueRank
}

func (m *_VariableTypeAttributes) GetArrayDimensions() []uint32 {
	return m.ArrayDimensions
}

func (m *_VariableTypeAttributes) GetIsAbstract() bool {
	return m.IsAbstract
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariableTypeAttributes(structType any) VariableTypeAttributes {
	if casted, ok := structType.(VariableTypeAttributes); ok {
		return casted
	}
	if casted, ok := structType.(*VariableTypeAttributes); ok {
		return *casted
	}
	return nil
}

func (m *_VariableTypeAttributes) GetTypeName() string {
	return "VariableTypeAttributes"
}

func (m *_VariableTypeAttributes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (specifiedAttributes)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Simple field (writeMask)
	lengthInBits += 32

	// Simple field (userWriteMask)
	lengthInBits += 32

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	// Simple field (dataType)
	lengthInBits += m.DataType.GetLengthInBits(ctx)

	// Simple field (valueRank)
	lengthInBits += 32

	// Implicit Field (noOfArrayDimensions)
	lengthInBits += 32

	// Array field
	if len(m.ArrayDimensions) > 0 {
		lengthInBits += 32 * uint16(len(m.ArrayDimensions))
	}

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isAbstract)
	lengthInBits += 1

	return lengthInBits
}

func (m *_VariableTypeAttributes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariableTypeAttributes) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__variableTypeAttributes VariableTypeAttributes, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariableTypeAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariableTypeAttributes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	specifiedAttributes, err := ReadSimpleField(ctx, "specifiedAttributes", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'specifiedAttributes' field"))
	}
	m.SpecifiedAttributes = specifiedAttributes

	displayName, err := ReadSimpleField[LocalizedText](ctx, "displayName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'displayName' field"))
	}
	m.DisplayName = displayName

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	writeMask, err := ReadSimpleField(ctx, "writeMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeMask' field"))
	}
	m.WriteMask = writeMask

	userWriteMask, err := ReadSimpleField(ctx, "userWriteMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userWriteMask' field"))
	}
	m.UserWriteMask = userWriteMask

	value, err := ReadSimpleField[Variant](ctx, "value", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	dataType, err := ReadSimpleField[NodeId](ctx, "dataType", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataType' field"))
	}
	m.DataType = dataType

	valueRank, err := ReadSimpleField(ctx, "valueRank", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'valueRank' field"))
	}
	m.ValueRank = valueRank

	noOfArrayDimensions, err := ReadImplicitField[int32](ctx, "noOfArrayDimensions", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfArrayDimensions' field"))
	}
	_ = noOfArrayDimensions

	arrayDimensions, err := ReadCountArrayField[uint32](ctx, "arrayDimensions", ReadUnsignedInt(readBuffer, uint8(32)), uint64(noOfArrayDimensions))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayDimensions' field"))
	}
	m.ArrayDimensions = arrayDimensions

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isAbstract, err := ReadSimpleField(ctx, "isAbstract", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isAbstract' field"))
	}
	m.IsAbstract = isAbstract

	if closeErr := readBuffer.CloseContext("VariableTypeAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariableTypeAttributes")
	}

	return m, nil
}

func (m *_VariableTypeAttributes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariableTypeAttributes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariableTypeAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariableTypeAttributes")
		}

		if err := WriteSimpleField[uint32](ctx, "specifiedAttributes", m.GetSpecifiedAttributes(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'specifiedAttributes' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "displayName", m.GetDisplayName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'displayName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if err := WriteSimpleField[uint32](ctx, "writeMask", m.GetWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeMask' field")
		}

		if err := WriteSimpleField[uint32](ctx, "userWriteMask", m.GetUserWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'userWriteMask' field")
		}

		if err := WriteSimpleField[Variant](ctx, "value", m.GetValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "dataType", m.GetDataType(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataType' field")
		}

		if err := WriteSimpleField[int32](ctx, "valueRank", m.GetValueRank(), WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'valueRank' field")
		}
		noOfArrayDimensions := int32(utils.InlineIf(bool((m.GetArrayDimensions()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetArrayDimensions()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfArrayDimensions", noOfArrayDimensions, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfArrayDimensions' field")
		}

		if err := WriteSimpleTypeArrayField(ctx, "arrayDimensions", m.GetArrayDimensions(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayDimensions' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "isAbstract", m.GetIsAbstract(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isAbstract' field")
		}

		if popErr := writeBuffer.PopContext("VariableTypeAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariableTypeAttributes")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariableTypeAttributes) IsVariableTypeAttributes() {}

func (m *_VariableTypeAttributes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariableTypeAttributes) deepCopy() *_VariableTypeAttributes {
	if m == nil {
		return nil
	}
	_VariableTypeAttributesCopy := &_VariableTypeAttributes{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SpecifiedAttributes,
		utils.DeepCopy[LocalizedText](m.DisplayName),
		utils.DeepCopy[LocalizedText](m.Description),
		m.WriteMask,
		m.UserWriteMask,
		utils.DeepCopy[Variant](m.Value),
		utils.DeepCopy[NodeId](m.DataType),
		m.ValueRank,
		utils.DeepCopySlice[uint32, uint32](m.ArrayDimensions),
		m.IsAbstract,
		m.reservedField0,
	}
	_VariableTypeAttributesCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _VariableTypeAttributesCopy
}

func (m *_VariableTypeAttributes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
