/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableNon is an enum
type OpcuaNodeIdServicesVariableNon int32

type IOpcuaNodeIdServicesVariableNon interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray                      OpcuaNodeIdServicesVariableNon = 2040
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState                           OpcuaNodeIdServicesVariableNon = 9963
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id                        OpcuaNodeIdServicesVariableNon = 9964
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name                      OpcuaNodeIdServicesVariableNon = 9965
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number                    OpcuaNodeIdServicesVariableNon = 9966
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName      OpcuaNodeIdServicesVariableNon = 9967
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime            OpcuaNodeIdServicesVariableNon = 9968
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime   OpcuaNodeIdServicesVariableNon = 9969
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState                 OpcuaNodeIdServicesVariableNon = 9970
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState                OpcuaNodeIdServicesVariableNon = 9971
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState                         OpcuaNodeIdServicesVariableNon = 10020
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id                      OpcuaNodeIdServicesVariableNon = 10021
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name                    OpcuaNodeIdServicesVariableNon = 10022
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number                  OpcuaNodeIdServicesVariableNon = 10023
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName    OpcuaNodeIdServicesVariableNon = 10024
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime          OpcuaNodeIdServicesVariableNon = 10025
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime OpcuaNodeIdServicesVariableNon = 10026
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState               OpcuaNodeIdServicesVariableNon = 10027
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState              OpcuaNodeIdServicesVariableNon = 10028
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState                             OpcuaNodeIdServicesVariableNon = 10029
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id                          OpcuaNodeIdServicesVariableNon = 10030
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name                        OpcuaNodeIdServicesVariableNon = 10031
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number                      OpcuaNodeIdServicesVariableNon = 10032
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName        OpcuaNodeIdServicesVariableNon = 10033
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime              OpcuaNodeIdServicesVariableNon = 10034
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime     OpcuaNodeIdServicesVariableNon = 10035
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState                   OpcuaNodeIdServicesVariableNon = 10036
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState                  OpcuaNodeIdServicesVariableNon = 10037
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState                              OpcuaNodeIdServicesVariableNon = 10038
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id                           OpcuaNodeIdServicesVariableNon = 10039
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name                         OpcuaNodeIdServicesVariableNon = 10040
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number                       OpcuaNodeIdServicesVariableNon = 10041
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName         OpcuaNodeIdServicesVariableNon = 10042
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime               OpcuaNodeIdServicesVariableNon = 10043
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime      OpcuaNodeIdServicesVariableNon = 10044
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState                    OpcuaNodeIdServicesVariableNon = 10045
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState                   OpcuaNodeIdServicesVariableNon = 10046
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState                           OpcuaNodeIdServicesVariableNon = 10047
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id                        OpcuaNodeIdServicesVariableNon = 10048
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name                      OpcuaNodeIdServicesVariableNon = 10049
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number                    OpcuaNodeIdServicesVariableNon = 10050
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName      OpcuaNodeIdServicesVariableNon = 10051
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime            OpcuaNodeIdServicesVariableNon = 10052
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime   OpcuaNodeIdServicesVariableNon = 10053
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState                 OpcuaNodeIdServicesVariableNon = 10054
	OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState                OpcuaNodeIdServicesVariableNon = 10055
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode                      OpcuaNodeIdServicesVariableNon = 10522
	OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups          OpcuaNodeIdServicesVariableNon = 11948
	OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode                  OpcuaNodeIdServicesVariableNon = 16776
	OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits               OpcuaNodeIdServicesVariableNon = 16858
	OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_RedundantServerArray          OpcuaNodeIdServicesVariableNon = 32413
	OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_Mode                          OpcuaNodeIdServicesVariableNon = 32415
)

var OpcuaNodeIdServicesVariableNonValues []OpcuaNodeIdServicesVariableNon

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableNonValues = []OpcuaNodeIdServicesVariableNon{
		OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode,
		OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups,
		OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode,
		OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits,
		OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_RedundantServerArray,
		OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_Mode,
	}
}

func OpcuaNodeIdServicesVariableNonByValue(value int32) (enum OpcuaNodeIdServicesVariableNon, ok bool) {
	switch value {
	case 10020:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState, true
	case 10021:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id, true
	case 10022:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name, true
	case 10023:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number, true
	case 10024:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName, true
	case 10025:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime, true
	case 10026:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime, true
	case 10027:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState, true
	case 10028:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState, true
	case 10029:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState, true
	case 10030:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id, true
	case 10031:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name, true
	case 10032:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number, true
	case 10033:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName, true
	case 10034:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime, true
	case 10035:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime, true
	case 10036:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState, true
	case 10037:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState, true
	case 10038:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState, true
	case 10039:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id, true
	case 10040:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name, true
	case 10041:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number, true
	case 10042:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName, true
	case 10043:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime, true
	case 10044:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime, true
	case 10045:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState, true
	case 10046:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState, true
	case 10047:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState, true
	case 10048:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id, true
	case 10049:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name, true
	case 10050:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number, true
	case 10051:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName, true
	case 10052:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime, true
	case 10053:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime, true
	case 10054:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState, true
	case 10055:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState, true
	case 10522:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode, true
	case 11948:
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups, true
	case 16776:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode, true
	case 16858:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits, true
	case 2040:
		return OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray, true
	case 32413:
		return OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_RedundantServerArray, true
	case 32415:
		return OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_Mode, true
	case 9963:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState, true
	case 9964:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id, true
	case 9965:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name, true
	case 9966:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number, true
	case 9967:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName, true
	case 9968:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime, true
	case 9969:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime, true
	case 9970:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState, true
	case 9971:
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableNonByName(value string) (enum OpcuaNodeIdServicesVariableNon, ok bool) {
	switch value {
	case "NonExclusiveLimitAlarmType_HighHighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState, true
	case "NonExclusiveLimitAlarmType_HighHighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id, true
	case "NonExclusiveLimitAlarmType_HighHighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name, true
	case "NonExclusiveLimitAlarmType_HighHighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number, true
	case "NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_HighHighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_HighHighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState, true
	case "NonExclusiveLimitAlarmType_HighHighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState, true
	case "NonExclusiveLimitAlarmType_HighState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState, true
	case "NonExclusiveLimitAlarmType_HighState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id, true
	case "NonExclusiveLimitAlarmType_HighState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name, true
	case "NonExclusiveLimitAlarmType_HighState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number, true
	case "NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_HighState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_HighState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState, true
	case "NonExclusiveLimitAlarmType_HighState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState, true
	case "NonExclusiveLimitAlarmType_LowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState, true
	case "NonExclusiveLimitAlarmType_LowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id, true
	case "NonExclusiveLimitAlarmType_LowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name, true
	case "NonExclusiveLimitAlarmType_LowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number, true
	case "NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_LowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_LowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState, true
	case "NonExclusiveLimitAlarmType_LowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState, true
	case "NonExclusiveLimitAlarmType_LowLowState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState, true
	case "NonExclusiveLimitAlarmType_LowLowState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id, true
	case "NonExclusiveLimitAlarmType_LowLowState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name, true
	case "NonExclusiveLimitAlarmType_LowLowState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number, true
	case "NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_LowLowState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_LowLowState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState, true
	case "NonExclusiveLimitAlarmType_LowLowState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState, true
	case "NonExclusiveDeviationAlarmType_SetpointNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode, true
	case "NonTransparentNetworkRedundancyType_ServerNetworkGroups":
		return OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups, true
	case "NonExclusiveDeviationAlarmType_BaseSetpointNode":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode, true
	case "NonExclusiveRateOfChangeAlarmType_EngineeringUnits":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits, true
	case "NonTransparentRedundancyType_ServerUriArray":
		return OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray, true
	case "NonTransparentBackupRedundancyType_RedundantServerArray":
		return OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_RedundantServerArray, true
	case "NonTransparentBackupRedundancyType_Mode":
		return OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_Mode, true
	case "NonExclusiveLimitAlarmType_ActiveState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState, true
	case "NonExclusiveLimitAlarmType_ActiveState_Id":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id, true
	case "NonExclusiveLimitAlarmType_ActiveState_Name":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name, true
	case "NonExclusiveLimitAlarmType_ActiveState_Number":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number, true
	case "NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName, true
	case "NonExclusiveLimitAlarmType_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime, true
	case "NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime, true
	case "NonExclusiveLimitAlarmType_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState, true
	case "NonExclusiveLimitAlarmType_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableNonKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableNonValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableNon(structType any) OpcuaNodeIdServicesVariableNon {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableNon {
		if sOpcuaNodeIdServicesVariableNon, ok := typ.(OpcuaNodeIdServicesVariableNon); ok {
			return sOpcuaNodeIdServicesVariableNon
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableNon) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableNon) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableNonParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableNon, error) {
	return OpcuaNodeIdServicesVariableNonParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableNonParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableNon, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableNon", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableNon")
	}
	if enum, ok := OpcuaNodeIdServicesVariableNonByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableNon")
		return OpcuaNodeIdServicesVariableNon(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableNon) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableNon) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableNon", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableNon) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableNon) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState:
		return "NonExclusiveLimitAlarmType_HighHighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Id:
		return "NonExclusiveLimitAlarmType_HighHighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Name:
		return "NonExclusiveLimitAlarmType_HighHighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_Number:
		return "NonExclusiveLimitAlarmType_HighHighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TransitionTime:
		return "NonExclusiveLimitAlarmType_HighHighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_TrueState:
		return "NonExclusiveLimitAlarmType_HighHighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighHighState_FalseState:
		return "NonExclusiveLimitAlarmType_HighHighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState:
		return "NonExclusiveLimitAlarmType_HighState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Id:
		return "NonExclusiveLimitAlarmType_HighState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Name:
		return "NonExclusiveLimitAlarmType_HighState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_Number:
		return "NonExclusiveLimitAlarmType_HighState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TransitionTime:
		return "NonExclusiveLimitAlarmType_HighState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_TrueState:
		return "NonExclusiveLimitAlarmType_HighState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_HighState_FalseState:
		return "NonExclusiveLimitAlarmType_HighState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState:
		return "NonExclusiveLimitAlarmType_LowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Id:
		return "NonExclusiveLimitAlarmType_LowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Name:
		return "NonExclusiveLimitAlarmType_LowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_Number:
		return "NonExclusiveLimitAlarmType_LowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TransitionTime:
		return "NonExclusiveLimitAlarmType_LowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_TrueState:
		return "NonExclusiveLimitAlarmType_LowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowState_FalseState:
		return "NonExclusiveLimitAlarmType_LowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState:
		return "NonExclusiveLimitAlarmType_LowLowState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Id:
		return "NonExclusiveLimitAlarmType_LowLowState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Name:
		return "NonExclusiveLimitAlarmType_LowLowState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_Number:
		return "NonExclusiveLimitAlarmType_LowLowState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TransitionTime:
		return "NonExclusiveLimitAlarmType_LowLowState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_TrueState:
		return "NonExclusiveLimitAlarmType_LowLowState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_LowLowState_FalseState:
		return "NonExclusiveLimitAlarmType_LowLowState_FalseState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_SetpointNode:
		return "NonExclusiveDeviationAlarmType_SetpointNode"
	case OpcuaNodeIdServicesVariableNon_NonTransparentNetworkRedundancyType_ServerNetworkGroups:
		return "NonTransparentNetworkRedundancyType_ServerNetworkGroups"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveDeviationAlarmType_BaseSetpointNode:
		return "NonExclusiveDeviationAlarmType_BaseSetpointNode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveRateOfChangeAlarmType_EngineeringUnits:
		return "NonExclusiveRateOfChangeAlarmType_EngineeringUnits"
	case OpcuaNodeIdServicesVariableNon_NonTransparentRedundancyType_ServerUriArray:
		return "NonTransparentRedundancyType_ServerUriArray"
	case OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_RedundantServerArray:
		return "NonTransparentBackupRedundancyType_RedundantServerArray"
	case OpcuaNodeIdServicesVariableNon_NonTransparentBackupRedundancyType_Mode:
		return "NonTransparentBackupRedundancyType_Mode"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState:
		return "NonExclusiveLimitAlarmType_ActiveState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Id:
		return "NonExclusiveLimitAlarmType_ActiveState_Id"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Name:
		return "NonExclusiveLimitAlarmType_ActiveState_Name"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_Number:
		return "NonExclusiveLimitAlarmType_ActiveState_Number"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName:
		return "NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TransitionTime:
		return "NonExclusiveLimitAlarmType_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime:
		return "NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_TrueState:
		return "NonExclusiveLimitAlarmType_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableNon_NonExclusiveLimitAlarmType_ActiveState_FalseState:
		return "NonExclusiveLimitAlarmType_ActiveState_FalseState"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableNon) String() string {
	return e.PLC4XEnumName()
}
