/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataTypeAttributes is the corresponding interface of DataTypeAttributes
type DataTypeAttributes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSpecifiedAttributes returns SpecifiedAttributes (property field)
	GetSpecifiedAttributes() uint32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// GetWriteMask returns WriteMask (property field)
	GetWriteMask() uint32
	// GetUserWriteMask returns UserWriteMask (property field)
	GetUserWriteMask() uint32
	// GetIsAbstract returns IsAbstract (property field)
	GetIsAbstract() bool
	// IsDataTypeAttributes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataTypeAttributes()
	// CreateBuilder creates a DataTypeAttributesBuilder
	CreateDataTypeAttributesBuilder() DataTypeAttributesBuilder
}

// _DataTypeAttributes is the data-structure of this message
type _DataTypeAttributes struct {
	ExtensionObjectDefinitionContract
	SpecifiedAttributes uint32
	DisplayName         LocalizedText
	Description         LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	IsAbstract          bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ DataTypeAttributes = (*_DataTypeAttributes)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DataTypeAttributes)(nil)

// NewDataTypeAttributes factory function for _DataTypeAttributes
func NewDataTypeAttributes(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, isAbstract bool) *_DataTypeAttributes {
	if displayName == nil {
		panic("displayName of type LocalizedText for DataTypeAttributes must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for DataTypeAttributes must not be nil")
	}
	_result := &_DataTypeAttributes{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SpecifiedAttributes:               specifiedAttributes,
		DisplayName:                       displayName,
		Description:                       description,
		WriteMask:                         writeMask,
		UserWriteMask:                     userWriteMask,
		IsAbstract:                        isAbstract,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataTypeAttributesBuilder is a builder for DataTypeAttributes
type DataTypeAttributesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, isAbstract bool) DataTypeAttributesBuilder
	// WithSpecifiedAttributes adds SpecifiedAttributes (property field)
	WithSpecifiedAttributes(uint32) DataTypeAttributesBuilder
	// WithDisplayName adds DisplayName (property field)
	WithDisplayName(LocalizedText) DataTypeAttributesBuilder
	// WithDisplayNameBuilder adds DisplayName (property field) which is build by the builder
	WithDisplayNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) DataTypeAttributesBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) DataTypeAttributesBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) DataTypeAttributesBuilder
	// WithWriteMask adds WriteMask (property field)
	WithWriteMask(uint32) DataTypeAttributesBuilder
	// WithUserWriteMask adds UserWriteMask (property field)
	WithUserWriteMask(uint32) DataTypeAttributesBuilder
	// WithIsAbstract adds IsAbstract (property field)
	WithIsAbstract(bool) DataTypeAttributesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DataTypeAttributes or returns an error if something is wrong
	Build() (DataTypeAttributes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataTypeAttributes
}

// NewDataTypeAttributesBuilder() creates a DataTypeAttributesBuilder
func NewDataTypeAttributesBuilder() DataTypeAttributesBuilder {
	return &_DataTypeAttributesBuilder{_DataTypeAttributes: new(_DataTypeAttributes)}
}

type _DataTypeAttributesBuilder struct {
	*_DataTypeAttributes

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (DataTypeAttributesBuilder) = (*_DataTypeAttributesBuilder)(nil)

func (b *_DataTypeAttributesBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DataTypeAttributes
}

func (b *_DataTypeAttributesBuilder) WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, isAbstract bool) DataTypeAttributesBuilder {
	return b.WithSpecifiedAttributes(specifiedAttributes).WithDisplayName(displayName).WithDescription(description).WithWriteMask(writeMask).WithUserWriteMask(userWriteMask).WithIsAbstract(isAbstract)
}

func (b *_DataTypeAttributesBuilder) WithSpecifiedAttributes(specifiedAttributes uint32) DataTypeAttributesBuilder {
	b.SpecifiedAttributes = specifiedAttributes
	return b
}

func (b *_DataTypeAttributesBuilder) WithDisplayName(displayName LocalizedText) DataTypeAttributesBuilder {
	b.DisplayName = displayName
	return b
}

func (b *_DataTypeAttributesBuilder) WithDisplayNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) DataTypeAttributesBuilder {
	builder := builderSupplier(b.DisplayName.CreateLocalizedTextBuilder())
	var err error
	b.DisplayName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_DataTypeAttributesBuilder) WithDescription(description LocalizedText) DataTypeAttributesBuilder {
	b.Description = description
	return b
}

func (b *_DataTypeAttributesBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) DataTypeAttributesBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_DataTypeAttributesBuilder) WithWriteMask(writeMask uint32) DataTypeAttributesBuilder {
	b.WriteMask = writeMask
	return b
}

func (b *_DataTypeAttributesBuilder) WithUserWriteMask(userWriteMask uint32) DataTypeAttributesBuilder {
	b.UserWriteMask = userWriteMask
	return b
}

func (b *_DataTypeAttributesBuilder) WithIsAbstract(isAbstract bool) DataTypeAttributesBuilder {
	b.IsAbstract = isAbstract
	return b
}

func (b *_DataTypeAttributesBuilder) Build() (DataTypeAttributes, error) {
	if b.DisplayName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'displayName' not set"))
	}
	if b.Description == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'description' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DataTypeAttributes.deepCopy(), nil
}

func (b *_DataTypeAttributesBuilder) MustBuild() DataTypeAttributes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataTypeAttributesBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DataTypeAttributesBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DataTypeAttributesBuilder) DeepCopy() any {
	_copy := b.CreateDataTypeAttributesBuilder().(*_DataTypeAttributesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDataTypeAttributesBuilder creates a DataTypeAttributesBuilder
func (b *_DataTypeAttributes) CreateDataTypeAttributesBuilder() DataTypeAttributesBuilder {
	if b == nil {
		return NewDataTypeAttributesBuilder()
	}
	return &_DataTypeAttributesBuilder{_DataTypeAttributes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataTypeAttributes) GetExtensionId() int32 {
	return int32(372)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataTypeAttributes) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataTypeAttributes) GetSpecifiedAttributes() uint32 {
	return m.SpecifiedAttributes
}

func (m *_DataTypeAttributes) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_DataTypeAttributes) GetDescription() LocalizedText {
	return m.Description
}

func (m *_DataTypeAttributes) GetWriteMask() uint32 {
	return m.WriteMask
}

func (m *_DataTypeAttributes) GetUserWriteMask() uint32 {
	return m.UserWriteMask
}

func (m *_DataTypeAttributes) GetIsAbstract() bool {
	return m.IsAbstract
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDataTypeAttributes(structType any) DataTypeAttributes {
	if casted, ok := structType.(DataTypeAttributes); ok {
		return casted
	}
	if casted, ok := structType.(*DataTypeAttributes); ok {
		return *casted
	}
	return nil
}

func (m *_DataTypeAttributes) GetTypeName() string {
	return "DataTypeAttributes"
}

func (m *_DataTypeAttributes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (specifiedAttributes)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Simple field (writeMask)
	lengthInBits += 32

	// Simple field (userWriteMask)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isAbstract)
	lengthInBits += 1

	return lengthInBits
}

func (m *_DataTypeAttributes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DataTypeAttributes) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__dataTypeAttributes DataTypeAttributes, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataTypeAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataTypeAttributes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	specifiedAttributes, err := ReadSimpleField(ctx, "specifiedAttributes", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'specifiedAttributes' field"))
	}
	m.SpecifiedAttributes = specifiedAttributes

	displayName, err := ReadSimpleField[LocalizedText](ctx, "displayName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'displayName' field"))
	}
	m.DisplayName = displayName

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	writeMask, err := ReadSimpleField(ctx, "writeMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeMask' field"))
	}
	m.WriteMask = writeMask

	userWriteMask, err := ReadSimpleField(ctx, "userWriteMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userWriteMask' field"))
	}
	m.UserWriteMask = userWriteMask

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isAbstract, err := ReadSimpleField(ctx, "isAbstract", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isAbstract' field"))
	}
	m.IsAbstract = isAbstract

	if closeErr := readBuffer.CloseContext("DataTypeAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataTypeAttributes")
	}

	return m, nil
}

func (m *_DataTypeAttributes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataTypeAttributes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataTypeAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataTypeAttributes")
		}

		if err := WriteSimpleField[uint32](ctx, "specifiedAttributes", m.GetSpecifiedAttributes(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'specifiedAttributes' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "displayName", m.GetDisplayName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'displayName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if err := WriteSimpleField[uint32](ctx, "writeMask", m.GetWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeMask' field")
		}

		if err := WriteSimpleField[uint32](ctx, "userWriteMask", m.GetUserWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'userWriteMask' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "isAbstract", m.GetIsAbstract(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isAbstract' field")
		}

		if popErr := writeBuffer.PopContext("DataTypeAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataTypeAttributes")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataTypeAttributes) IsDataTypeAttributes() {}

func (m *_DataTypeAttributes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataTypeAttributes) deepCopy() *_DataTypeAttributes {
	if m == nil {
		return nil
	}
	_DataTypeAttributesCopy := &_DataTypeAttributes{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SpecifiedAttributes,
		utils.DeepCopy[LocalizedText](m.DisplayName),
		utils.DeepCopy[LocalizedText](m.Description),
		m.WriteMask,
		m.UserWriteMask,
		m.IsAbstract,
		m.reservedField0,
	}
	_DataTypeAttributesCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DataTypeAttributesCopy
}

func (m *_DataTypeAttributes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
