/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"
	"strconv"
	"strings"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/knxnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type KnxnetipXmlParserHelper struct {
}

// Temporary imports to silent compiler warnings (TODO: migrate from static to emission based imports)
func init() {
	_ = strconv.ParseUint
	_ = strconv.ParseInt
	_ = strings.Join
	_ = utils.Dump
}

func (m KnxnetipXmlParserHelper) Parse(typeName string, xmlString string, parserArguments ...string) (any, error) {
	switch typeName {
	case "KnxProperty":
		propertyType, _ := KnxPropertyDataTypeByName(parserArguments[0])
		parsedUint1, err := strconv.ParseUint(parserArguments[1], 10, 8)
		if err != nil {
			return nil, err
		}
		dataLengthInBytes := uint8(parsedUint1)
		return KnxPropertyParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), propertyType, dataLengthInBytes)
	case "HPAIControlEndpoint":
		return HPAIControlEndpointParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "TunnelingResponseDataBlock":
		return TunnelingResponseDataBlockParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "DeviceDescriptorType2":
		return DeviceDescriptorType2ParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ChannelInformation":
		return ChannelInformationParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "KnxDatapoint":
		datapointType, _ := KnxDatapointTypeByName(parserArguments[0])
		return KnxDatapointParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), datapointType)
	case "DeviceConfigurationAckDataBlock":
		return DeviceConfigurationAckDataBlockParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ConnectionRequestInformation":
		return ConnectionRequestInformationParseWithBuffer[ConnectionRequestInformation](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "Apdu":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		dataLength := uint8(parsedUint0)
		return ApduParseWithBuffer[Apdu](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), dataLength)
	case "HPAIDiscoveryEndpoint":
		return HPAIDiscoveryEndpointParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ProjectInstallationIdentifier":
		return ProjectInstallationIdentifierParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ServiceId":
		return ServiceIdParseWithBuffer[ServiceId](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "HPAIDataEndpoint":
		return HPAIDataEndpointParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "RelativeTimestamp":
		return RelativeTimestampParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "CEMI":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 16)
		if err != nil {
			return nil, err
		}
		size := uint16(parsedUint0)
		return CEMIParseWithBuffer[CEMI](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), size)
	case "KnxNetIpMessage":
		return KnxNetIpMessageParseWithBuffer[KnxNetIpMessage](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "DeviceStatus":
		return DeviceStatusParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "IPAddress":
		return IPAddressParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "GroupObjectDescriptorRealisationTypeB":
		return GroupObjectDescriptorRealisationTypeBParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "CEMIAdditionalInformation":
		return CEMIAdditionalInformationParseWithBuffer[CEMIAdditionalInformation](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ComObjectTable":
		firmwareType, _ := FirmwareTypeByName(parserArguments[0])
		return ComObjectTableParseWithBuffer[ComObjectTable](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), firmwareType)
	case "KnxAddress":
		return KnxAddressParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ConnectionResponseDataBlock":
		return ConnectionResponseDataBlockParseWithBuffer[ConnectionResponseDataBlock](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "TunnelingRequestDataBlock":
		return TunnelingRequestDataBlockParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "DIBDeviceInfo":
		return DIBDeviceInfoParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "DeviceConfigurationRequestDataBlock":
		return DeviceConfigurationRequestDataBlockParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "DIBSuppSvcFamilies":
		return DIBSuppSvcFamiliesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "LDataFrame":
		return LDataFrameParseWithBuffer[LDataFrame](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ApduDataExt":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		length := uint8(parsedUint0)
		return ApduDataExtParseWithBuffer[ApduDataExt](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), length)
	case "ApduControl":
		return ApduControlParseWithBuffer[ApduControl](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "KnxGroupAddress":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 2)
		if err != nil {
			return nil, err
		}
		numLevels := uint8(parsedUint0)
		return KnxGroupAddressParseWithBuffer[KnxGroupAddress](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), numLevels)
	case "GroupObjectDescriptorRealisationType6":
		return GroupObjectDescriptorRealisationType6ParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "GroupObjectDescriptorRealisationType7":
		return GroupObjectDescriptorRealisationType7ParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "MACAddress":
		return MACAddressParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "GroupObjectDescriptorRealisationType2":
		return GroupObjectDescriptorRealisationType2ParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ApduData":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		dataLength := uint8(parsedUint0)
		return ApduDataParseWithBuffer[ApduData](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), dataLength)
	case "GroupObjectDescriptorRealisationType1":
		return GroupObjectDescriptorRealisationType1ParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
