/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AirConditioningData is the corresponding interface of AirConditioningData
type AirConditioningData interface {
	AirConditioningDataContract
	AirConditioningDataRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsAirConditioningData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAirConditioningData()
	// CreateBuilder creates a AirConditioningDataBuilder
	CreateAirConditioningDataBuilder() AirConditioningDataBuilder
}

// AirConditioningDataContract provides a set of functions which can be overwritten by a sub struct
type AirConditioningDataContract interface {
	// GetCommandTypeContainer returns CommandTypeContainer (property field)
	GetCommandTypeContainer() AirConditioningCommandTypeContainer
	// GetCommandType returns CommandType (virtual field)
	GetCommandType() AirConditioningCommandType
	// IsAirConditioningData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAirConditioningData()
	// CreateBuilder creates a AirConditioningDataBuilder
	CreateAirConditioningDataBuilder() AirConditioningDataBuilder
}

// AirConditioningDataRequirements provides a set of functions which need to be implemented by a sub struct
type AirConditioningDataRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetCommandType returns CommandType (discriminator field)
	GetCommandType() AirConditioningCommandType
}

// _AirConditioningData is the data-structure of this message
type _AirConditioningData struct {
	_SubType interface {
		AirConditioningDataContract
		AirConditioningDataRequirements
	}
	CommandTypeContainer AirConditioningCommandTypeContainer
}

var _ AirConditioningDataContract = (*_AirConditioningData)(nil)

// NewAirConditioningData factory function for _AirConditioningData
func NewAirConditioningData(commandTypeContainer AirConditioningCommandTypeContainer) *_AirConditioningData {
	return &_AirConditioningData{CommandTypeContainer: commandTypeContainer}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AirConditioningDataBuilder is a builder for AirConditioningData
type AirConditioningDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(commandTypeContainer AirConditioningCommandTypeContainer) AirConditioningDataBuilder
	// WithCommandTypeContainer adds CommandTypeContainer (property field)
	WithCommandTypeContainer(AirConditioningCommandTypeContainer) AirConditioningDataBuilder
	// AsAirConditioningDataHvacScheduleEntry converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataHvacScheduleEntry() AirConditioningDataHvacScheduleEntryBuilder
	// AsAirConditioningDataHumidityScheduleEntry converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataHumidityScheduleEntry() AirConditioningDataHumidityScheduleEntryBuilder
	// AsAirConditioningDataRefresh converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataRefresh() AirConditioningDataRefreshBuilder
	// AsAirConditioningDataZoneHvacPlantStatus converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataZoneHvacPlantStatus() AirConditioningDataZoneHvacPlantStatusBuilder
	// AsAirConditioningDataZoneHumidityPlantStatus converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataZoneHumidityPlantStatus() AirConditioningDataZoneHumidityPlantStatusBuilder
	// AsAirConditioningDataZoneTemperature converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataZoneTemperature() AirConditioningDataZoneTemperatureBuilder
	// AsAirConditioningDataZoneHumidity converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataZoneHumidity() AirConditioningDataZoneHumidityBuilder
	// AsAirConditioningDataSetZoneGroupOff converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetZoneGroupOff() AirConditioningDataSetZoneGroupOffBuilder
	// AsAirConditioningDataSetZoneGroupOn converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetZoneGroupOn() AirConditioningDataSetZoneGroupOnBuilder
	// AsAirConditioningDataSetZoneHvacMode converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetZoneHvacMode() AirConditioningDataSetZoneHvacModeBuilder
	// AsAirConditioningDataSetPlantHvacLevel converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetPlantHvacLevel() AirConditioningDataSetPlantHvacLevelBuilder
	// AsAirConditioningDataSetZoneHumidityMode converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetZoneHumidityMode() AirConditioningDataSetZoneHumidityModeBuilder
	// AsAirConditioningDataSetPlantHumidityLevel converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetPlantHumidityLevel() AirConditioningDataSetPlantHumidityLevelBuilder
	// AsAirConditioningDataSetHvacUpperGuardLimit converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetHvacUpperGuardLimit() AirConditioningDataSetHvacUpperGuardLimitBuilder
	// AsAirConditioningDataSetHvacLowerGuardLimit converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetHvacLowerGuardLimit() AirConditioningDataSetHvacLowerGuardLimitBuilder
	// AsAirConditioningDataSetHvacSetbackLimit converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetHvacSetbackLimit() AirConditioningDataSetHvacSetbackLimitBuilder
	// AsAirConditioningDataSetHumidityUpperGuardLimit converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetHumidityUpperGuardLimit() AirConditioningDataSetHumidityUpperGuardLimitBuilder
	// AsAirConditioningDataSetHumidityLowerGuardLimit converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetHumidityLowerGuardLimit() AirConditioningDataSetHumidityLowerGuardLimitBuilder
	// AsAirConditioningDataSetHumiditySetbackLimit converts this build to a subType of AirConditioningData. It is always possible to return to current builder using Done()
	AsAirConditioningDataSetHumiditySetbackLimit() AirConditioningDataSetHumiditySetbackLimitBuilder
	// Build builds the AirConditioningData or returns an error if something is wrong
	PartialBuild() (AirConditioningDataContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() AirConditioningDataContract
	// Build builds the AirConditioningData or returns an error if something is wrong
	Build() (AirConditioningData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AirConditioningData
}

// NewAirConditioningDataBuilder() creates a AirConditioningDataBuilder
func NewAirConditioningDataBuilder() AirConditioningDataBuilder {
	return &_AirConditioningDataBuilder{_AirConditioningData: new(_AirConditioningData)}
}

type _AirConditioningDataChildBuilder interface {
	utils.Copyable
	setParent(AirConditioningDataContract)
	buildForAirConditioningData() (AirConditioningData, error)
}

type _AirConditioningDataBuilder struct {
	*_AirConditioningData

	childBuilder _AirConditioningDataChildBuilder

	collectedErr []error
}

var _ (AirConditioningDataBuilder) = (*_AirConditioningDataBuilder)(nil)

func (b *_AirConditioningDataBuilder) WithMandatoryFields(commandTypeContainer AirConditioningCommandTypeContainer) AirConditioningDataBuilder {
	return b.WithCommandTypeContainer(commandTypeContainer)
}

func (b *_AirConditioningDataBuilder) WithCommandTypeContainer(commandTypeContainer AirConditioningCommandTypeContainer) AirConditioningDataBuilder {
	b.CommandTypeContainer = commandTypeContainer
	return b
}

func (b *_AirConditioningDataBuilder) PartialBuild() (AirConditioningDataContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AirConditioningData.deepCopy(), nil
}

func (b *_AirConditioningDataBuilder) PartialMustBuild() AirConditioningDataContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataHvacScheduleEntry() AirConditioningDataHvacScheduleEntryBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataHvacScheduleEntryBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataHvacScheduleEntryBuilder().(*_AirConditioningDataHvacScheduleEntryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataHumidityScheduleEntry() AirConditioningDataHumidityScheduleEntryBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataHumidityScheduleEntryBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataHumidityScheduleEntryBuilder().(*_AirConditioningDataHumidityScheduleEntryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataRefresh() AirConditioningDataRefreshBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataRefreshBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataRefreshBuilder().(*_AirConditioningDataRefreshBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataZoneHvacPlantStatus() AirConditioningDataZoneHvacPlantStatusBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataZoneHvacPlantStatusBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataZoneHvacPlantStatusBuilder().(*_AirConditioningDataZoneHvacPlantStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataZoneHumidityPlantStatus() AirConditioningDataZoneHumidityPlantStatusBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataZoneHumidityPlantStatusBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataZoneHumidityPlantStatusBuilder().(*_AirConditioningDataZoneHumidityPlantStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataZoneTemperature() AirConditioningDataZoneTemperatureBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataZoneTemperatureBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataZoneTemperatureBuilder().(*_AirConditioningDataZoneTemperatureBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataZoneHumidity() AirConditioningDataZoneHumidityBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataZoneHumidityBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataZoneHumidityBuilder().(*_AirConditioningDataZoneHumidityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetZoneGroupOff() AirConditioningDataSetZoneGroupOffBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetZoneGroupOffBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetZoneGroupOffBuilder().(*_AirConditioningDataSetZoneGroupOffBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetZoneGroupOn() AirConditioningDataSetZoneGroupOnBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetZoneGroupOnBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetZoneGroupOnBuilder().(*_AirConditioningDataSetZoneGroupOnBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetZoneHvacMode() AirConditioningDataSetZoneHvacModeBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetZoneHvacModeBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetZoneHvacModeBuilder().(*_AirConditioningDataSetZoneHvacModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetPlantHvacLevel() AirConditioningDataSetPlantHvacLevelBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetPlantHvacLevelBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetPlantHvacLevelBuilder().(*_AirConditioningDataSetPlantHvacLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetZoneHumidityMode() AirConditioningDataSetZoneHumidityModeBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetZoneHumidityModeBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetZoneHumidityModeBuilder().(*_AirConditioningDataSetZoneHumidityModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetPlantHumidityLevel() AirConditioningDataSetPlantHumidityLevelBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetPlantHumidityLevelBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetPlantHumidityLevelBuilder().(*_AirConditioningDataSetPlantHumidityLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetHvacUpperGuardLimit() AirConditioningDataSetHvacUpperGuardLimitBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetHvacUpperGuardLimitBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetHvacUpperGuardLimitBuilder().(*_AirConditioningDataSetHvacUpperGuardLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetHvacLowerGuardLimit() AirConditioningDataSetHvacLowerGuardLimitBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetHvacLowerGuardLimitBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetHvacLowerGuardLimitBuilder().(*_AirConditioningDataSetHvacLowerGuardLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetHvacSetbackLimit() AirConditioningDataSetHvacSetbackLimitBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetHvacSetbackLimitBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetHvacSetbackLimitBuilder().(*_AirConditioningDataSetHvacSetbackLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetHumidityUpperGuardLimit() AirConditioningDataSetHumidityUpperGuardLimitBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetHumidityUpperGuardLimitBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetHumidityUpperGuardLimitBuilder().(*_AirConditioningDataSetHumidityUpperGuardLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetHumidityLowerGuardLimit() AirConditioningDataSetHumidityLowerGuardLimitBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetHumidityLowerGuardLimitBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetHumidityLowerGuardLimitBuilder().(*_AirConditioningDataSetHumidityLowerGuardLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) AsAirConditioningDataSetHumiditySetbackLimit() AirConditioningDataSetHumiditySetbackLimitBuilder {
	if cb, ok := b.childBuilder.(AirConditioningDataSetHumiditySetbackLimitBuilder); ok {
		return cb
	}
	cb := NewAirConditioningDataSetHumiditySetbackLimitBuilder().(*_AirConditioningDataSetHumiditySetbackLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_AirConditioningDataBuilder) Build() (AirConditioningData, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForAirConditioningData()
}

func (b *_AirConditioningDataBuilder) MustBuild() AirConditioningData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AirConditioningDataBuilder) DeepCopy() any {
	_copy := b.CreateAirConditioningDataBuilder().(*_AirConditioningDataBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_AirConditioningDataChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAirConditioningDataBuilder creates a AirConditioningDataBuilder
func (b *_AirConditioningData) CreateAirConditioningDataBuilder() AirConditioningDataBuilder {
	if b == nil {
		return NewAirConditioningDataBuilder()
	}
	return &_AirConditioningDataBuilder{_AirConditioningData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AirConditioningData) GetCommandTypeContainer() AirConditioningCommandTypeContainer {
	return m.CommandTypeContainer
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_AirConditioningData) GetCommandType() AirConditioningCommandType {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return CastAirConditioningCommandType(m.GetCommandTypeContainer().CommandType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAirConditioningData(structType any) AirConditioningData {
	if casted, ok := structType.(AirConditioningData); ok {
		return casted
	}
	if casted, ok := structType.(*AirConditioningData); ok {
		return *casted
	}
	return nil
}

func (m *_AirConditioningData) GetTypeName() string {
	return "AirConditioningData"
}

func (m *_AirConditioningData) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (commandTypeContainer)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_AirConditioningData) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_AirConditioningData) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func AirConditioningDataParse[T AirConditioningData](ctx context.Context, theBytes []byte) (T, error) {
	return AirConditioningDataParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func AirConditioningDataParseWithBufferProducer[T AirConditioningData]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := AirConditioningDataParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func AirConditioningDataParseWithBuffer[T AirConditioningData](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_AirConditioningData{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_AirConditioningData) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__airConditioningData AirConditioningData, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AirConditioningData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AirConditioningData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(KnowsAirConditioningCommandTypeContainer(ctx, readBuffer)) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "no command type could be found"})
	}

	commandTypeContainer, err := ReadEnumField[AirConditioningCommandTypeContainer](ctx, "commandTypeContainer", "AirConditioningCommandTypeContainer", ReadEnum(AirConditioningCommandTypeContainerByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandTypeContainer' field"))
	}
	m.CommandTypeContainer = commandTypeContainer

	commandType, err := ReadVirtualField[AirConditioningCommandType](ctx, "commandType", (*AirConditioningCommandType)(nil), commandTypeContainer.CommandType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandType' field"))
	}
	_ = commandType

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child AirConditioningData
	switch {
	case commandType == AirConditioningCommandType_HVAC_SCHEDULE_ENTRY: // AirConditioningDataHvacScheduleEntry
		if _child, err = new(_AirConditioningDataHvacScheduleEntry).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataHvacScheduleEntry for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_HUMIDITY_SCHEDULE_ENTRY: // AirConditioningDataHumidityScheduleEntry
		if _child, err = new(_AirConditioningDataHumidityScheduleEntry).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataHumidityScheduleEntry for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_REFRESH: // AirConditioningDataRefresh
		if _child, err = new(_AirConditioningDataRefresh).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataRefresh for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_ZONE_HVAC_PLANT_STATUS: // AirConditioningDataZoneHvacPlantStatus
		if _child, err = new(_AirConditioningDataZoneHvacPlantStatus).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataZoneHvacPlantStatus for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_ZONE_HUMIDITY_PLANT_STATUS: // AirConditioningDataZoneHumidityPlantStatus
		if _child, err = new(_AirConditioningDataZoneHumidityPlantStatus).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataZoneHumidityPlantStatus for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_ZONE_TEMPERATURE: // AirConditioningDataZoneTemperature
		if _child, err = new(_AirConditioningDataZoneTemperature).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataZoneTemperature for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_ZONE_HUMIDITY: // AirConditioningDataZoneHumidity
		if _child, err = new(_AirConditioningDataZoneHumidity).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataZoneHumidity for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_ZONE_GROUP_OFF: // AirConditioningDataSetZoneGroupOff
		if _child, err = new(_AirConditioningDataSetZoneGroupOff).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetZoneGroupOff for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_ZONE_GROUP_ON: // AirConditioningDataSetZoneGroupOn
		if _child, err = new(_AirConditioningDataSetZoneGroupOn).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetZoneGroupOn for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_ZONE_HVAC_MODE: // AirConditioningDataSetZoneHvacMode
		if _child, err = new(_AirConditioningDataSetZoneHvacMode).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetZoneHvacMode for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_PLANT_HVAC_LEVEL: // AirConditioningDataSetPlantHvacLevel
		if _child, err = new(_AirConditioningDataSetPlantHvacLevel).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetPlantHvacLevel for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_ZONE_HUMIDITY_MODE: // AirConditioningDataSetZoneHumidityMode
		if _child, err = new(_AirConditioningDataSetZoneHumidityMode).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetZoneHumidityMode for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_PLANT_HUMIDITY_LEVEL: // AirConditioningDataSetPlantHumidityLevel
		if _child, err = new(_AirConditioningDataSetPlantHumidityLevel).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetPlantHumidityLevel for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_HVAC_UPPER_GUARD_LIMIT: // AirConditioningDataSetHvacUpperGuardLimit
		if _child, err = new(_AirConditioningDataSetHvacUpperGuardLimit).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetHvacUpperGuardLimit for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_HVAC_LOWER_GUARD_LIMIT: // AirConditioningDataSetHvacLowerGuardLimit
		if _child, err = new(_AirConditioningDataSetHvacLowerGuardLimit).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetHvacLowerGuardLimit for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_HVAC_SETBACK_LIMIT: // AirConditioningDataSetHvacSetbackLimit
		if _child, err = new(_AirConditioningDataSetHvacSetbackLimit).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetHvacSetbackLimit for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_HUMIDITY_UPPER_GUARD_LIMIT: // AirConditioningDataSetHumidityUpperGuardLimit
		if _child, err = new(_AirConditioningDataSetHumidityUpperGuardLimit).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetHumidityUpperGuardLimit for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_HUMIDITY_LOWER_GUARD_LIMIT: // AirConditioningDataSetHumidityLowerGuardLimit
		if _child, err = new(_AirConditioningDataSetHumidityLowerGuardLimit).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetHumidityLowerGuardLimit for type-switch of AirConditioningData")
		}
	case commandType == AirConditioningCommandType_SET_HUMIDITY_SETBACK_LIMIT: // AirConditioningDataSetHumiditySetbackLimit
		if _child, err = new(_AirConditioningDataSetHumiditySetbackLimit).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AirConditioningDataSetHumiditySetbackLimit for type-switch of AirConditioningData")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [commandType=%v]", commandType)
	}

	if closeErr := readBuffer.CloseContext("AirConditioningData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AirConditioningData")
	}

	return _child, nil
}

func (pm *_AirConditioningData) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child AirConditioningData, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AirConditioningData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AirConditioningData")
	}

	if err := WriteSimpleEnumField[AirConditioningCommandTypeContainer](ctx, "commandTypeContainer", "AirConditioningCommandTypeContainer", m.GetCommandTypeContainer(), WriteEnum[AirConditioningCommandTypeContainer, uint8](AirConditioningCommandTypeContainer.GetValue, AirConditioningCommandTypeContainer.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'commandTypeContainer' field")
	}
	// Virtual field
	commandType := m.GetCommandType()
	_ = commandType
	if _commandTypeErr := writeBuffer.WriteVirtual(ctx, "commandType", m.GetCommandType()); _commandTypeErr != nil {
		return errors.Wrap(_commandTypeErr, "Error serializing 'commandType' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("AirConditioningData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AirConditioningData")
	}
	return nil
}

func (m *_AirConditioningData) IsAirConditioningData() {}

func (m *_AirConditioningData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AirConditioningData) deepCopy() *_AirConditioningData {
	if m == nil {
		return nil
	}
	_AirConditioningDataCopy := &_AirConditioningData{
		nil, // will be set by child
		m.CommandTypeContainer,
	}
	return _AirConditioningDataCopy
}
