/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesLiftCarDoorCommand is the corresponding interface of BACnetPropertyStatesLiftCarDoorCommand
type BACnetPropertyStatesLiftCarDoorCommand interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetLiftCarDoorCommand returns LiftCarDoorCommand (property field)
	GetLiftCarDoorCommand() BACnetLiftCarDoorCommandTagged
	// IsBACnetPropertyStatesLiftCarDoorCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesLiftCarDoorCommand()
	// CreateBuilder creates a BACnetPropertyStatesLiftCarDoorCommandBuilder
	CreateBACnetPropertyStatesLiftCarDoorCommandBuilder() BACnetPropertyStatesLiftCarDoorCommandBuilder
}

// _BACnetPropertyStatesLiftCarDoorCommand is the data-structure of this message
type _BACnetPropertyStatesLiftCarDoorCommand struct {
	BACnetPropertyStatesContract
	LiftCarDoorCommand BACnetLiftCarDoorCommandTagged
}

var _ BACnetPropertyStatesLiftCarDoorCommand = (*_BACnetPropertyStatesLiftCarDoorCommand)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesLiftCarDoorCommand)(nil)

// NewBACnetPropertyStatesLiftCarDoorCommand factory function for _BACnetPropertyStatesLiftCarDoorCommand
func NewBACnetPropertyStatesLiftCarDoorCommand(peekedTagHeader BACnetTagHeader, liftCarDoorCommand BACnetLiftCarDoorCommandTagged) *_BACnetPropertyStatesLiftCarDoorCommand {
	if liftCarDoorCommand == nil {
		panic("liftCarDoorCommand of type BACnetLiftCarDoorCommandTagged for BACnetPropertyStatesLiftCarDoorCommand must not be nil")
	}
	_result := &_BACnetPropertyStatesLiftCarDoorCommand{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		LiftCarDoorCommand:           liftCarDoorCommand,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesLiftCarDoorCommandBuilder is a builder for BACnetPropertyStatesLiftCarDoorCommand
type BACnetPropertyStatesLiftCarDoorCommandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(liftCarDoorCommand BACnetLiftCarDoorCommandTagged) BACnetPropertyStatesLiftCarDoorCommandBuilder
	// WithLiftCarDoorCommand adds LiftCarDoorCommand (property field)
	WithLiftCarDoorCommand(BACnetLiftCarDoorCommandTagged) BACnetPropertyStatesLiftCarDoorCommandBuilder
	// WithLiftCarDoorCommandBuilder adds LiftCarDoorCommand (property field) which is build by the builder
	WithLiftCarDoorCommandBuilder(func(BACnetLiftCarDoorCommandTaggedBuilder) BACnetLiftCarDoorCommandTaggedBuilder) BACnetPropertyStatesLiftCarDoorCommandBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesLiftCarDoorCommand or returns an error if something is wrong
	Build() (BACnetPropertyStatesLiftCarDoorCommand, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesLiftCarDoorCommand
}

// NewBACnetPropertyStatesLiftCarDoorCommandBuilder() creates a BACnetPropertyStatesLiftCarDoorCommandBuilder
func NewBACnetPropertyStatesLiftCarDoorCommandBuilder() BACnetPropertyStatesLiftCarDoorCommandBuilder {
	return &_BACnetPropertyStatesLiftCarDoorCommandBuilder{_BACnetPropertyStatesLiftCarDoorCommand: new(_BACnetPropertyStatesLiftCarDoorCommand)}
}

type _BACnetPropertyStatesLiftCarDoorCommandBuilder struct {
	*_BACnetPropertyStatesLiftCarDoorCommand

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesLiftCarDoorCommandBuilder) = (*_BACnetPropertyStatesLiftCarDoorCommandBuilder)(nil)

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesLiftCarDoorCommand
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) WithMandatoryFields(liftCarDoorCommand BACnetLiftCarDoorCommandTagged) BACnetPropertyStatesLiftCarDoorCommandBuilder {
	return b.WithLiftCarDoorCommand(liftCarDoorCommand)
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) WithLiftCarDoorCommand(liftCarDoorCommand BACnetLiftCarDoorCommandTagged) BACnetPropertyStatesLiftCarDoorCommandBuilder {
	b.LiftCarDoorCommand = liftCarDoorCommand
	return b
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) WithLiftCarDoorCommandBuilder(builderSupplier func(BACnetLiftCarDoorCommandTaggedBuilder) BACnetLiftCarDoorCommandTaggedBuilder) BACnetPropertyStatesLiftCarDoorCommandBuilder {
	builder := builderSupplier(b.LiftCarDoorCommand.CreateBACnetLiftCarDoorCommandTaggedBuilder())
	var err error
	b.LiftCarDoorCommand, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetLiftCarDoorCommandTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) Build() (BACnetPropertyStatesLiftCarDoorCommand, error) {
	if b.LiftCarDoorCommand == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'liftCarDoorCommand' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesLiftCarDoorCommand.deepCopy(), nil
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) MustBuild() BACnetPropertyStatesLiftCarDoorCommand {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesLiftCarDoorCommandBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesLiftCarDoorCommandBuilder().(*_BACnetPropertyStatesLiftCarDoorCommandBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesLiftCarDoorCommandBuilder creates a BACnetPropertyStatesLiftCarDoorCommandBuilder
func (b *_BACnetPropertyStatesLiftCarDoorCommand) CreateBACnetPropertyStatesLiftCarDoorCommandBuilder() BACnetPropertyStatesLiftCarDoorCommandBuilder {
	if b == nil {
		return NewBACnetPropertyStatesLiftCarDoorCommandBuilder()
	}
	return &_BACnetPropertyStatesLiftCarDoorCommandBuilder{_BACnetPropertyStatesLiftCarDoorCommand: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesLiftCarDoorCommand) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesLiftCarDoorCommand) GetLiftCarDoorCommand() BACnetLiftCarDoorCommandTagged {
	return m.LiftCarDoorCommand
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesLiftCarDoorCommand(structType any) BACnetPropertyStatesLiftCarDoorCommand {
	if casted, ok := structType.(BACnetPropertyStatesLiftCarDoorCommand); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesLiftCarDoorCommand); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) GetTypeName() string {
	return "BACnetPropertyStatesLiftCarDoorCommand"
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (liftCarDoorCommand)
	lengthInBits += m.LiftCarDoorCommand.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesLiftCarDoorCommand BACnetPropertyStatesLiftCarDoorCommand, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesLiftCarDoorCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesLiftCarDoorCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	liftCarDoorCommand, err := ReadSimpleField[BACnetLiftCarDoorCommandTagged](ctx, "liftCarDoorCommand", ReadComplex[BACnetLiftCarDoorCommandTagged](BACnetLiftCarDoorCommandTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'liftCarDoorCommand' field"))
	}
	m.LiftCarDoorCommand = liftCarDoorCommand

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesLiftCarDoorCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesLiftCarDoorCommand")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesLiftCarDoorCommand"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesLiftCarDoorCommand")
		}

		if err := WriteSimpleField[BACnetLiftCarDoorCommandTagged](ctx, "liftCarDoorCommand", m.GetLiftCarDoorCommand(), WriteComplex[BACnetLiftCarDoorCommandTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'liftCarDoorCommand' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesLiftCarDoorCommand"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesLiftCarDoorCommand")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) IsBACnetPropertyStatesLiftCarDoorCommand() {}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) deepCopy() *_BACnetPropertyStatesLiftCarDoorCommand {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesLiftCarDoorCommandCopy := &_BACnetPropertyStatesLiftCarDoorCommand{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetLiftCarDoorCommandTagged](m.LiftCarDoorCommand),
	}
	_BACnetPropertyStatesLiftCarDoorCommandCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesLiftCarDoorCommandCopy
}

func (m *_BACnetPropertyStatesLiftCarDoorCommand) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
