/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.plugins.codegenerator.language.mspec.model.fields;

import org.apache.plc4x.plugins.codegenerator.types.fields.PaddingField;
import org.apache.plc4x.plugins.codegenerator.types.references.SimpleTypeReference;
import org.apache.plc4x.plugins.codegenerator.types.terms.Term;

import java.util.Map;
import java.util.Objects;

public class DefaultPaddingField extends DefaultTypedNamedField implements PaddingField {

    private final Term paddingValue;
    private final Term paddingCondition;

    public DefaultPaddingField(Map<String, Term> attributes, SimpleTypeReference type, String name, Term paddingValue, Term paddingCondition) {
        super(attributes, name);
        this.paddingValue = Objects.requireNonNull(paddingValue);
        this.paddingCondition = Objects.requireNonNull(paddingCondition);
        this.type = type;
    }

    public Term getPaddingValue() {
        return paddingValue;
    }

    public Term getPaddingCondition() {
        return paddingCondition;
    }

    @Override
    public String toString() {
        return "DefaultPaddingField{" +
            "paddingValue=" + paddingValue +
            ", paddingCondition=" + paddingCondition +
            "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DefaultPaddingField that = (DefaultPaddingField) o;
        return Objects.equals(paddingValue, that.paddingValue) && Objects.equals(paddingCondition, that.paddingCondition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), paddingValue, paddingCondition);
    }
}
