/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.TypedQuery;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.DelegatingQuery;
import org.apache.openjpa.kernel.DelegatingResultList;
import org.apache.openjpa.kernel.DistinctResultList;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.AbstractQuery;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.FetchPlanImpl;
import org.apache.openjpa.persistence.HintHandler;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.LockTimeoutException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryOperationType;
import org.apache.openjpa.persistence.QueryTimeoutException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;

public class QueryImpl<X>
extends AbstractQuery<X>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private transient FetchPlan _fetch;
    private String _id;
    private transient ReentrantLock _lock = null;
    private HintHandler _hintHandler;
    private DelegatingQuery _query;

    public QueryImpl(EntityManagerImpl em, RuntimeExceptionTranslator ret, Query query, QueryMetaData qmd) {
        super(qmd, em);
        this._query = new DelegatingQuery(query, ret);
        this._lock = new ReentrantLock();
        if (query.getLanguage() == "openjpa.SQL") {
            this._convertPositionalParams = false;
        } else {
            Compatibility compat = query.getStoreContext().getConfiguration().getCompatibilityInstance();
            this._convertPositionalParams = compat.getConvertPositionalParametersToNamed();
        }
    }

    @Deprecated
    public QueryImpl(EntityManagerImpl em, RuntimeExceptionTranslator ret, Query query) {
        this(em, ret, query, null);
    }

    @Deprecated
    public QueryImpl(EntityManagerImpl em, Query query) {
        this(em, null, query, null);
    }

    public Query getDelegate() {
        return this._query.getDelegate();
    }

    @Override
    public OpenJPAEntityManager getEntityManager() {
        return this._em;
    }

    @Override
    public String getLanguage() {
        return this._query.getLanguage();
    }

    @Override
    public QueryOperationType getOperation() {
        return QueryOperationType.fromKernelConstant(this._query.getOperation());
    }

    @Override
    public FetchPlan getFetchPlan() {
        this._em.assertNotCloseInvoked();
        this._query.assertNotSerialized();
        this._query.lock();
        try {
            if (this._fetch == null) {
                this._fetch = ((EntityManagerFactoryImpl)this._em.getEntityManagerFactory()).toFetchPlan(this._query.getBroker(), this._query.getFetchConfiguration());
            }
            FetchPlan fetchPlan = this._fetch;
            return fetchPlan;
        }
        finally {
            this._query.unlock();
        }
    }

    @Override
    public String getQueryString() {
        String result = this._query.getQueryString();
        return result != null ? result : this._id;
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._query.getIgnoreChanges();
    }

    @Override
    public OpenJPAQuery<X> setIgnoreChanges(boolean ignore) {
        this._em.assertNotCloseInvoked();
        this._query.setIgnoreChanges(ignore);
        return this;
    }

    @Override
    public OpenJPAQuery<X> addFilterListener(FilterListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.addFilterListener(listener);
        return this;
    }

    @Override
    public OpenJPAQuery<X> removeFilterListener(FilterListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.removeFilterListener(listener);
        return this;
    }

    @Override
    public OpenJPAQuery<X> addAggregateListener(AggregateListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.addAggregateListener(listener);
        return this;
    }

    @Override
    public OpenJPAQuery<X> removeAggregateListener(AggregateListener listener) {
        this._em.assertNotCloseInvoked();
        this._query.removeAggregateListener(listener);
        return this;
    }

    @Override
    public Collection<?> getCandidateCollection() {
        return this._query.getCandidateCollection();
    }

    @Override
    public OpenJPAQuery<X> setCandidateCollection(Collection coll) {
        this._em.assertNotCloseInvoked();
        this._query.setCandidateCollection(coll);
        return this;
    }

    @Override
    public Class getResultClass() {
        Class res = this._query.getResultType();
        if (res != null) {
            return res;
        }
        return this._query.getCandidateType();
    }

    @Override
    public OpenJPAQuery<X> setResultClass(Class cls) {
        this._em.assertNotCloseInvoked();
        if (ImplHelper.isManagedType(this._em.getConfiguration(), cls)) {
            this._query.setCandidateType(cls, true);
        } else {
            this._query.setResultType(cls);
        }
        return this;
    }

    @Override
    public boolean hasSubclasses() {
        return this._query.hasSubclasses();
    }

    @Override
    public OpenJPAQuery<X> setSubclasses(boolean subs) {
        this._em.assertNotCloseInvoked();
        Class cls = this._query.getCandidateType();
        this._query.setCandidateExtent(this._query.getBroker().newExtent(cls, subs));
        return this;
    }

    @Override
    public int getFirstResult() {
        return QueryImpl.asInt(this._query.getStartRange());
    }

    @Override
    public OpenJPAQuery<X> setFirstResult(int startPosition) {
        this._em.assertNotCloseInvoked();
        long end = this._query.getEndRange() == Long.MAX_VALUE ? Long.MAX_VALUE : (long)startPosition + (this._query.getEndRange() - this._query.getStartRange());
        this._query.setRange(startPosition, end);
        return this;
    }

    @Override
    public int getMaxResults() {
        return QueryImpl.asInt(this._query.getEndRange() - this._query.getStartRange());
    }

    @Override
    public OpenJPAQuery<X> setMaxResults(int max) {
        this._em.assertNotCloseInvoked();
        long start = this._query.getStartRange();
        if (max == Integer.MAX_VALUE) {
            this._query.setRange(start, Long.MAX_VALUE);
        } else {
            this._query.setRange(start, start + (long)max);
        }
        return this;
    }

    @Override
    public OpenJPAQuery<X> compile() {
        this._em.assertNotCloseInvoked();
        this._query.compile();
        return this;
    }

    private Object execute() {
        if (!this.isNative() && this._query.getOperation() != 1) {
            throw new InvalidStateException(_loc.get("not-select-query", this.getQueryString()), null, null, false);
        }
        try {
            this.lock();
            Map<Object, Object> params = this.getParameterValues();
            boolean registered = this.preExecute(params);
            Object result = this._query.execute((Map)params);
            if (registered) {
                this.postExecute(result);
            }
            Object object = result;
            return object;
        }
        catch (LockTimeoutException e) {
            throw new QueryTimeoutException(e.getMessage(), new Throwable[]{e}, (Object)this);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getResultList() {
        this._em.assertNotCloseInvoked();
        boolean queryFetchPlanUsed = this.pushQueryFetchPlan();
        try {
            Object ob = this.execute();
            if (ob instanceof List) {
                List ret = (List)ob;
                if (ret instanceof ResultList) {
                    RuntimeExceptionTranslator trans = PersistenceExceptions.getRollbackTranslator(this._em);
                    if (this._query.isDistinct()) {
                        DistinctResultList distinctResultList = new DistinctResultList((ResultList)ret, trans);
                        return distinctResultList;
                    }
                    DelegatingResultList delegatingResultList = new DelegatingResultList((ResultList)ret, trans);
                    return delegatingResultList;
                }
                List list = ret;
                return list;
            }
            List<Object> list = Collections.singletonList(ob);
            return list;
        }
        finally {
            this.popQueryFetchPlan(queryFetchPlanUsed);
        }
    }

    @Override
    public X getSingleResult() {
        this._em.assertNotCloseInvoked();
        this.setHint("openjpa.hint.OptimizeResultCount", 1);
        boolean queryFetchPlanUsed = this.pushQueryFetchPlan();
        try {
            Object e;
            List result = this.getResultList();
            if (result == null || result.isEmpty()) {
                throw new NoResultException(_loc.get("no-result", this.getQueryString()).getMessage());
            }
            if (result.size() > 1) {
                throw new NonUniqueResultException(_loc.get("non-unique-result", this.getQueryString(), result.size()).getMessage());
            }
            try {
                e = result.get(0);
            }
            catch (Exception e2) {
                throw new NoResultException(_loc.get("no-result", this.getQueryString()).getMessage());
            }
            return (X)e;
        }
        finally {
            this.popQueryFetchPlan(queryFetchPlanUsed);
        }
    }

    private boolean pushQueryFetchPlan() {
        boolean fcPushed = false;
        if (this._hintHandler != null) {
            FetchConfiguration fc = this._fetch == null ? null : ((FetchPlanImpl)this._fetch).getDelegate();
            this._em.pushFetchPlan(fc);
            return true;
        }
        if (this._fetch != null && this._hintHandler != null) {
            switch (this._fetch.getReadLockMode()) {
                case PESSIMISTIC_READ: 
                case PESSIMISTIC_WRITE: 
                case PESSIMISTIC_FORCE_INCREMENT: {
                    this._em.pushFetchPlan(((FetchPlanImpl)this._fetch).getDelegate());
                    fcPushed = true;
                }
            }
        }
        return fcPushed;
    }

    private void popQueryFetchPlan(boolean queryFetchPlanUsed) {
        if (queryFetchPlanUsed) {
            this._em.popFetchPlan();
        }
    }

    @Override
    public int executeUpdate() {
        this._em.assertNotCloseInvoked();
        Map<Object, Object> paramValues = this.getParameterValues();
        if (this._query.getOperation() == 2) {
            return QueryImpl.asInt(paramValues.isEmpty() ? this._query.deleteAll() : this._query.deleteAll((Map)paramValues));
        }
        if (this._query.getOperation() == 3) {
            return QueryImpl.asInt(paramValues.isEmpty() ? this._query.updateAll() : this._query.updateAll((Map)paramValues));
        }
        throw new InvalidStateException(_loc.get("not-update-delete-query", this.getQueryString()), null, null, false);
    }

    private static int asInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    @Override
    public FlushModeType getFlushMode() {
        return EntityManagerImpl.fromFlushBeforeQueries(this._query.getFetchConfiguration().getFlushBeforeQueries());
    }

    @Override
    public OpenJPAQuery<X> setFlushMode(FlushModeType flushMode) {
        this._em.assertNotCloseInvoked();
        this._query.getFetchConfiguration().setFlushBeforeQueries(EntityManagerImpl.toFlushBeforeQueries(flushMode));
        return this;
    }

    void assertJPQLOrCriteriaQuery() {
        String language = this.getLanguage();
        if ("jakarta.persistence.JPQL".equals(language) || "openjpa.prepared.SQL".equals(language) || "jakarta.persistence.criteria".equals(language)) {
            return;
        }
        throw new IllegalStateException(_loc.get("not-jpql-or-criteria-query").getMessage());
    }

    @Override
    public OpenJPAQuery<X> closeAll() {
        this._query.closeAll();
        return this;
    }

    @Override
    public String[] getDataStoreActions(Map params) {
        return this._query.getDataStoreActions(params);
    }

    @Override
    public LockModeType getLockMode() {
        this.assertJPQLOrCriteriaQuery();
        return this.getFetchPlan().getReadLockMode();
    }

    @Override
    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        String language = this.getLanguage();
        if ("openjpa.prepared.SQL".equals(language)) {
            this.ignorePreparedQuery();
        }
        this.assertJPQLOrCriteriaQuery();
        this.getFetchPlan().setReadLockMode(lockMode);
        return this;
    }

    public int hashCode() {
        return this._query == null ? 0 : this._query.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._query == null) {
            return false;
        }
        return this._query.equals(((QueryImpl)other)._query);
    }

    @Override
    public Map<String, Object> getHints() {
        if (this._hintHandler == null) {
            return Collections.emptyMap();
        }
        return this._hintHandler.getHints();
    }

    @Override
    public OpenJPAQuery<X> setHint(String key, Object value) {
        this._em.assertNotCloseInvoked();
        if (this._hintHandler == null) {
            this._hintHandler = new HintHandler(this);
        }
        this._hintHandler.setHint(key, value);
        return this;
    }

    @Override
    public Set<String> getSupportedHints() {
        if (this._hintHandler == null) {
            this._hintHandler = new HintHandler(this);
        }
        return this._hintHandler.getSupportedHints();
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        Object[] delegates;
        for (Object o : delegates = new Object[]{this._query.getInnermostDelegate(), this._query.getDelegate(), this._query, this}) {
            if (cls == null || cls == Object.class || !cls.isInstance(o)) continue;
            return (T)o;
        }
        PersistenceException ex = new PersistenceException(_loc.get("unwrap-query-invalid", cls).toString(), null, this, false);
        if (this._em.isActive()) {
            this._em.setRollbackOnly(ex);
        }
        throw ex;
    }

    private boolean preExecute(Map params) {
        PreparedQueryCache cache = this._em.getPreparedQueryCache();
        if (cache == null) {
            return false;
        }
        FetchConfiguration fetch = this._query.getFetchConfiguration();
        if (fetch.getReadLockLevel() != 0) {
            if (cache.get(this._id) != null) {
                this.ignorePreparedQuery();
            }
            return false;
        }
        for (Object val : params.values()) {
            if (val != null) continue;
            this.ignorePreparedQuery();
            return false;
        }
        Boolean registered = cache.register(this._id, this._query, fetch);
        boolean alreadyCached = registered == null;
        String lang = this._query.getLanguage();
        QueryStatistics<String> stats = cache.getStatistics();
        if (alreadyCached && "openjpa.prepared.SQL".equals(lang)) {
            PreparedQuery pq = this._em.getPreparedQuery(this._id);
            if (pq.isInitialized()) {
                try {
                    Map rep = pq.reparametrize(params, this._em.getBroker());
                    params.clear();
                    params.putAll(rep);
                }
                catch (UserException ue) {
                    this.invalidatePreparedQuery();
                    Log log = this._em.getConfiguration().getLog("openjpa.Runtime");
                    if (log.isWarnEnabled()) {
                        log.warn(ue.getMessage());
                    }
                    return false;
                }
            }
            stats.recordExecution(pq.getOriginalQuery());
        } else {
            stats.recordExecution(this.getQueryString());
        }
        return registered == Boolean.TRUE;
    }

    private boolean postExecute(Object result) {
        PreparedQueryCache cache = this._em.getPreparedQueryCache();
        if (cache == null) {
            return false;
        }
        return cache.initialize(this._id, result) != null;
    }

    boolean invalidatePreparedQuery() {
        PreparedQueryCache cache = this._em.getPreparedQueryCache();
        if (cache == null) {
            return false;
        }
        this.ignorePreparedQuery();
        return cache.invalidate(this._id);
    }

    void ignorePreparedQuery() {
        PreparedQuery cached = this._em.getPreparedQuery(this._id);
        if (cached == null) {
            return;
        }
        Broker broker = this._em.getBroker();
        String JPQL2 = "jakarta.persistence.JPQL";
        String jpql = this._id;
        Query newQuery = broker.newQuery(JPQL2, jpql);
        newQuery.getFetchConfiguration().copy(this._query.getFetchConfiguration());
        newQuery.compile();
        this._query = new DelegatingQuery(newQuery, this._em.getExceptionTranslator());
    }

    QueryImpl setId(String id) {
        this._id = id;
        return this;
    }

    @Override
    protected void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    @Override
    protected void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    @Override
    protected void assertOpen() {
        this._query.assertOpen();
    }

    @Override
    public OrderedMap<Object, Class<?>> getParamTypes() {
        return this._query.getOrderedParameterTypes();
    }

    public String toString() {
        String result = this._query.getQueryString();
        return result != null ? result : this._id;
    }
}

