/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.valueextraction;

import jakarta.validation.ValidationException;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bval.jsr.GraphContext;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;

public final class ExtractValues {
    private ExtractValues() {
    }

    public static List<GraphContext> extract(GraphContext context, ContainerElementKey containerElementKey, ValueExtractor<?> valueExtractor) {
        Validate.notNull(context, "context", new Object[0]);
        Validate.notNull(containerElementKey, "containerElementKey", new Object[0]);
        if (valueExtractor != null) {
            Exceptions.raiseIf(context.getValue() == null, IllegalStateException::new, "Cannot extract values from null", new Object[0]);
            Receiver receiver = new Receiver(context, containerElementKey);
            try {
                valueExtractor.extractValues(context.getValue(), (ValueExtractor.ValueReceiver)receiver);
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ValidationException((Throwable)e);
            }
            return receiver.result.optional().orElse(Collections.emptyList());
        }
        return Collections.singletonList(context);
    }

    private static class Receiver
    implements ValueExtractor.ValueReceiver {
        private final GraphContext context;
        private final ContainerElementKey containerElementKey;
        private final Lazy<List<GraphContext>> result = new Lazy<List>(ArrayList::new);

        Receiver(GraphContext context, ContainerElementKey containerElementKey) {
            this.context = context;
            this.containerElementKey = containerElementKey;
        }

        public void value(String nodeName, Object object) {
            this.addChild(new NodeImpl.ContainerElementNodeImpl(nodeName), object);
        }

        public void iterableValue(String nodeName, Object object) {
            NodeImpl.ContainerElementNodeImpl node = new NodeImpl.ContainerElementNodeImpl(nodeName);
            node.setInIterable(true);
            this.addChild(node, object);
        }

        public void indexedValue(String nodeName, int i, Object object) {
            NodeImpl.ContainerElementNodeImpl node = new NodeImpl.ContainerElementNodeImpl(nodeName);
            node.setIndex(i);
            this.addChild(node, object);
        }

        public void keyedValue(String nodeName, Object key, Object object) {
            NodeImpl.ContainerElementNodeImpl node = new NodeImpl.ContainerElementNodeImpl(nodeName);
            node.setKey(key);
            this.addChild(node, object);
        }

        private void addChild(NodeImpl node, Object value) {
            PathImpl path = this.context.getPath();
            path.addNode(node.inContainer(this.containerElementKey.getContainerClass(), this.containerElementKey.getTypeArgumentIndex()));
            this.result.get().add(this.context.child(path, value));
        }
    }
}

