/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSessionIoHandler
extends AbstractLoggingBean
implements IoHandler {
    protected AbstractSessionIoHandler() {
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        AbstractSession sshSession = (AbstractSession)ValidateUtils.checkNotNull((Object)this.createSession(ioSession), (String)"No session created for %s", (Object)ioSession);
        sshSession.signalSessionCreated(ioSession);
        sshSession.start();
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        AbstractSession session = AbstractSession.getSession(ioSession);
        session.close(true);
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        AbstractSession session = AbstractSession.getSession(ioSession, true);
        if (session == null) {
            throw new MissingAttachedSessionException("No session available to signal caught exception=" + cause.getClass().getSimpleName(), cause);
        }
        session.exceptionCaught(cause);
    }

    public void messageReceived(IoSession ioSession, Readable message) throws Exception {
        AbstractSession session = AbstractSession.getSession(ioSession);
        try {
            session.messageReceived(message);
        }
        catch (Error e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("messageReceived({}) failed {} to handle message: {}", new Object[]{ioSession, e.getClass().getSimpleName(), e.getMessage(), e});
            }
            throw new RuntimeSshException((Throwable)e);
        }
    }

    protected abstract AbstractSession createSession(IoSession var1) throws Exception;
}

