/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdminUriTemplate {
    public static final Pattern PATH_VARIABLE_REGEX = Pattern.compile("^\\{(.*)\\}$");
    private final String templateString;
    private final String[] templateParts;

    public AdminUriTemplate(String templateString) {
        this.templateString = templateString;
        this.templateParts = templateString.split("/");
    }

    public boolean matches(String url) {
        String[] urlParts = url.split("/");
        if (this.templateParts.length != urlParts.length) {
            return false;
        }
        for (int i = 0; i < this.templateParts.length; ++i) {
            boolean isVariable = AdminUriTemplate.isVariable(this.templateParts[i]);
            boolean areEqual = this.templateParts[i].equals(urlParts[i]);
            if (isVariable || areEqual) continue;
            return false;
        }
        return true;
    }

    public PathParams parse(String url) {
        PathParams pathParams = new PathParams();
        String[] urlParts = url.split("/");
        if (this.templateParts.length != urlParts.length) {
            throw new IllegalArgumentException(url + " does not match " + this.templateString);
        }
        for (int i = 0; i < this.templateParts.length; ++i) {
            Matcher matcher = PATH_VARIABLE_REGEX.matcher(this.templateParts[i]);
            boolean areEqual = this.templateParts[i].equals(urlParts[i]);
            Preconditions.checkArgument((areEqual || matcher.matches() ? 1 : 0) != 0, (Object)(url + " does not match " + this.templateString));
            if (!matcher.matches()) continue;
            String variableName = AdminUriTemplate.getVariableName(this.templateParts[i]);
            pathParams.put(variableName, urlParts[i]);
        }
        return pathParams;
    }

    public String render(PathParams pathParams) {
        StringBuilder sb = new StringBuilder();
        for (String templatePart : this.templateParts) {
            sb.append('/');
            if (AdminUriTemplate.isVariable(templatePart)) {
                String variableName = AdminUriTemplate.getVariableName(templatePart);
                String variableValue = (String)pathParams.get(variableName);
                if (variableValue == null) {
                    throw new IllegalArgumentException("Path parameter " + variableName + " was not bound");
                }
                sb.append(variableValue);
                continue;
            }
            sb.append(templatePart);
        }
        sb.deleteCharAt(0);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminUriTemplate that = (AdminUriTemplate)o;
        return Objects.equal((Object)this.templateString, (Object)that.templateString);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateString});
    }

    private static String getVariableName(String templatePart) {
        return templatePart.substring(1, templatePart.length() - 1);
    }

    private static boolean isVariable(String templatePart) {
        return PATH_VARIABLE_REGEX.matcher(templatePart).matches();
    }
}

