/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.replicator.nrt.FileMetaData;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.replicator.nrt.ReplicaNode;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;

public class CopyOneFile
implements Closeable {
    private final DataInput in;
    private final IndexOutput out;
    private final ReplicaNode dest;
    public final String name;
    public final String tmpName;
    public final FileMetaData metaData;
    public final long bytesToCopy;
    private final long copyStartNS;
    private final byte[] buffer;
    private long bytesCopied;

    public CopyOneFile(DataInput in, ReplicaNode dest, String name, FileMetaData metaData, byte[] buffer) throws IOException {
        this.in = in;
        this.name = name;
        this.dest = dest;
        this.buffer = buffer;
        this.out = dest.createTempOutput(name, "copy", IOContext.DEFAULT);
        this.tmpName = this.out.getName();
        this.bytesToCopy = metaData.length - 8L;
        if (Node.VERBOSE_FILES) {
            dest.message("file " + name + ": start copying to tmp file " + this.tmpName + " length=" + (8L + this.bytesToCopy));
        }
        this.copyStartNS = System.nanoTime();
        this.metaData = metaData;
        dest.startCopyFile(name);
    }

    public CopyOneFile(CopyOneFile other, DataInput in) {
        this.in = in;
        this.dest = other.dest;
        this.name = other.name;
        this.out = other.out;
        this.tmpName = other.tmpName;
        this.metaData = other.metaData;
        this.bytesCopied = other.bytesCopied;
        this.bytesToCopy = other.bytesToCopy;
        this.copyStartNS = other.copyStartNS;
        this.buffer = other.buffer;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.dest.finishCopyFile(this.name);
    }

    public boolean visit() throws IOException {
        for (int i = 0; i < 10; ++i) {
            long bytesLeft = this.bytesToCopy - this.bytesCopied;
            if (bytesLeft == 0L) {
                long checksum = this.out.getChecksum();
                if (checksum != this.metaData.checksum) {
                    this.dest.message("file " + this.tmpName + ": checksum mismatch after copy (bits flipped during network copy?) after-copy checksum=" + checksum + " vs expected=" + this.metaData.checksum + "; cancel job");
                    throw new IOException("file " + this.name + ": checksum mismatch after file copy");
                }
                long actualChecksumIn = CodecUtil.readBELong((DataInput)this.in);
                if (actualChecksumIn != checksum) {
                    this.dest.message("file " + this.tmpName + ": checksum claimed by primary disagrees with the file's footer: claimed checksum=" + checksum + " vs actual=" + actualChecksumIn);
                    throw new IOException("file " + this.name + ": checksum mismatch after file copy");
                }
                CodecUtil.writeBELong((DataOutput)this.out, (long)checksum);
                this.bytesCopied += 8L;
                this.close();
                if (Node.VERBOSE_FILES) {
                    this.dest.message(String.format(Locale.ROOT, "file %s: done copying [%s, %.3fms]", this.name, Node.bytesToString(this.metaData.length), (double)(System.nanoTime() - this.copyStartNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L)));
                }
                return true;
            }
            int toCopy = (int)Math.min(bytesLeft, (long)this.buffer.length);
            this.in.readBytes(this.buffer, 0, toCopy);
            this.out.writeBytes(this.buffer, 0, toCopy);
            this.bytesCopied += (long)toCopy;
        }
        return false;
    }

    public long getBytesCopied() {
        return this.bytesCopied;
    }
}

