/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util;

import java.lang.invoke.MethodHandles;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.util.LoggerFactory;

public final class ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void handle(Throwable t, MessageBroker messageBroker) {
        if (t instanceof LukeException) {
            Throwable cause = t.getCause();
            String message = cause == null ? t.getMessage() : t.getMessage() + " " + cause.getMessage();
            log.log(Level.WARNING, "Uncaught LukeException", t);
            messageBroker.showStatusMessage(message);
        } else {
            log.log(Level.SEVERE, "Uncaught Exception", t);
            messageBroker.showUnknownErrorMessage();
        }
    }
}

