/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.lucene.luke.app.DirectoryHandler;
import org.apache.lucene.luke.app.DirectoryObserver;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.AnalysisPanelProvider;
import org.apache.lucene.luke.app.desktop.components.CommitsPanelProvider;
import org.apache.lucene.luke.app.desktop.components.DocumentsPanelProvider;
import org.apache.lucene.luke.app.desktop.components.LogsPanelProvider;
import org.apache.lucene.luke.app.desktop.components.OverviewPanelProvider;
import org.apache.lucene.luke.app.desktop.components.SearchPanelProvider;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.TabUtils;

public final class TabbedPaneProvider
implements TabSwitcherProxy.TabSwitcher {
    private final MessageBroker messageBroker;
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JPanel overviewPanel = new OverviewPanelProvider().get();
    private final JPanel documentsPanel = new DocumentsPanelProvider().get();
    private final JPanel searchPanel = new SearchPanelProvider().get();
    private final JPanel analysisPanel = new AnalysisPanelProvider().get();
    private final JPanel commitsPanel = new CommitsPanelProvider().get();
    private final JPanel logsPanel = new LogsPanelProvider().get();

    public TabbedPaneProvider() throws IOException {
        this.messageBroker = MessageBroker.getInstance();
        TabSwitcherProxy.getInstance().set(this);
        Observer observer = new Observer();
        IndexHandler.getInstance().addObserver(observer);
        DirectoryHandler.getInstance().addObserver(observer);
    }

    public JTabbedPane get() {
        this.tabbedPane.addTab(FontUtils.elegantIconHtml("&#xe009;", "Overview"), this.overviewPanel);
        this.tabbedPane.addTab(FontUtils.elegantIconHtml("&#x69;", "Documents"), this.documentsPanel);
        this.tabbedPane.addTab(FontUtils.elegantIconHtml("&#xe101;", "Search"), this.searchPanel);
        this.tabbedPane.addTab(FontUtils.elegantIconHtml("&#xe104;", "Analysis"), this.analysisPanel);
        this.tabbedPane.addTab(FontUtils.elegantIconHtml("&#xe0ea;", "Commits"), this.commitsPanel);
        this.tabbedPane.addTab(FontUtils.elegantIconHtml("&#xe058;", "Logs"), this.logsPanel);
        TabUtils.forceTransparent(this.tabbedPane);
        return this.tabbedPane;
    }

    @Override
    public void switchTab(Tab tab) {
        this.tabbedPane.setSelectedIndex(tab.index());
        this.tabbedPane.setVisible(false);
        this.tabbedPane.setVisible(true);
        this.messageBroker.clearStatusMessage();
    }

    public static enum Tab {
        OVERVIEW(0),
        DOCUMENTS(1),
        SEARCH(2),
        ANALYZER(3),
        COMMITS(4);

        private int tabIdx;

        private Tab(int tabIdx) {
            this.tabIdx = tabIdx;
        }

        int index() {
            return this.tabIdx;
        }
    }

    private class Observer
    implements IndexObserver,
    DirectoryObserver {
        private Observer() {
        }

        @Override
        public void openDirectory(LukeState state) {
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.COMMITS.index(), true);
        }

        @Override
        public void closeDirectory() {
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.OVERVIEW.index(), false);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.DOCUMENTS.index(), false);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.SEARCH.index(), false);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.COMMITS.index(), false);
        }

        @Override
        public void openIndex(LukeState state) {
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.OVERVIEW.index(), true);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.DOCUMENTS.index(), true);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.SEARCH.index(), true);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.COMMITS.index(), true);
        }

        @Override
        public void closeIndex() {
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.OVERVIEW.index(), false);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.DOCUMENTS.index(), false);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.SEARCH.index(), false);
            TabbedPaneProvider.this.tabbedPane.setEnabledAt(Tab.COMMITS.index(), false);
        }
    }
}

