/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.quantization;

import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.VectorUtil;

public interface ScalarQuantizedVectorSimilarity {
    public static ScalarQuantizedVectorSimilarity fromVectorSimilarity(VectorSimilarityFunction sim, float constMultiplier, byte bits) {
        return switch (sim) {
            default -> throw new MatchException(null, null);
            case VectorSimilarityFunction.EUCLIDEAN -> new Euclidean(constMultiplier);
            case VectorSimilarityFunction.COSINE, VectorSimilarityFunction.DOT_PRODUCT -> new DotProduct(constMultiplier, bits <= 4 ? VectorUtil::int4DotProduct : VectorUtil::uint8DotProduct);
            case VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT -> new MaximumInnerProduct(constMultiplier, bits <= 4 ? VectorUtil::int4DotProduct : VectorUtil::uint8DotProduct);
        };
    }

    public float score(byte[] var1, float var2, byte[] var3, float var4);

    public static class Euclidean
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;

        public Euclidean(float constMultiplier) {
            this.constMultiplier = constMultiplier;
        }

        @Override
        public float score(byte[] queryVector, float queryVectorOffset, byte[] storedVector, float vectorOffset) {
            int squareDistance = VectorUtil.uint8SquareDistance(storedVector, queryVector);
            float adjustedDistance = (float)squareDistance * this.constMultiplier;
            return 1.0f / (1.0f + adjustedDistance);
        }
    }

    public static class DotProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;
        private final ByteVectorComparator comparator;

        public DotProduct(float constMultiplier, ByteVectorComparator comparator) {
            this.constMultiplier = constMultiplier;
            this.comparator = comparator;
        }

        @Override
        public float score(byte[] queryVector, float queryOffset, byte[] storedVector, float vectorOffset) {
            int dotProduct = this.comparator.compare(storedVector, queryVector);
            assert (dotProduct >= 0);
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return Math.max((1.0f + adjustedDistance) / 2.0f, 0.0f);
        }
    }

    public static interface ByteVectorComparator {
        public int compare(byte[] var1, byte[] var2);
    }

    public static class MaximumInnerProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;
        private final ByteVectorComparator comparator;

        public MaximumInnerProduct(float constMultiplier, ByteVectorComparator comparator) {
            this.constMultiplier = constMultiplier;
            this.comparator = comparator;
        }

        @Override
        public float score(byte[] queryVector, float queryOffset, byte[] storedVector, float vectorOffset) {
            int dotProduct = this.comparator.compare(storedVector, queryVector);
            assert (dotProduct >= 0);
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return VectorUtil.scaleMaxInnerProductScore(adjustedDistance);
        }
    }
}

