/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public interface VectorScorer {
    public static final int DEFAULT_BULK_BATCH_SIZE = 64;

    public float score() throws IOException;

    public DocIdSetIterator iterator();

    default public Bulk bulk(DocIdSetIterator matchingDocs) throws IOException {
        DocIdSetIterator iterator;
        DocIdSetIterator docIdSetIterator = iterator = matchingDocs == null ? this.iterator() : ConjunctionUtils.createConjunction(List.of(matchingDocs, this.iterator()), List.of());
        if (iterator.docID() == -1) {
            iterator.nextDoc();
        }
        return (upTo, liveDocs, buffer) -> {
            if (!1.$assertionsDisabled && upTo <= 0) {
                throw new AssertionError();
            }
            buffer.growNoCopy(64);
            int size = 0;
            float maxScore = Float.NEGATIVE_INFINITY;
            int doc = iterator.docID();
            while (doc < upTo && size < 64) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    buffer.docs[size] = doc;
                    buffer.features[size] = this.score();
                    maxScore = Math.max(maxScore, buffer.features[size]);
                    ++size;
                }
                doc = iterator.nextDoc();
            }
            buffer.size = size;
            return maxScore;
        };
    }

    public static interface Bulk {
        public float nextDocsAndScores(int var1, Bits var2, DocAndFloatFeatureBuffer var3) throws IOException;

        public static Bulk fromRandomScorerDense(RandomVectorScorer scorer, KnnVectorValues.DocIndexIterator iterator, DocIdSetIterator matchingDocs) {
            KnnVectorValues.DocIndexIterator matches = matchingDocs == null ? iterator : ConjunctionUtils.createConjunction(List.of(matchingDocs, iterator), List.of());
            return (upTo, liveDocs, buffer) -> {
                if (!1.$assertionsDisabled && upTo <= 0) {
                    throw new AssertionError();
                }
                if (matches.docID() == -1) {
                    matches.nextDoc();
                }
                buffer.growNoCopy(64);
                int size = 0;
                int doc = matches.docID();
                while (doc < upTo && size < 64) {
                    if (liveDocs == null || liveDocs.get(doc)) {
                        buffer.docs[size++] = doc;
                    }
                    doc = matches.nextDoc();
                }
                buffer.size = size;
                return scorer.bulkScore(buffer.docs, buffer.features, size);
            };
        }

        public static Bulk fromRandomScorerSparse(final RandomVectorScorer scorer, final KnnVectorValues.DocIndexIterator iterator, final DocIdSetIterator matchingDocs) {
            return new Bulk(){
                final DocIdSetIterator matches;
                int[] docIds;
                {
                    this.matches = matchingDocs == null ? iterator : ConjunctionUtils.createConjunction(List.of(matchingDocs, iterator), List.of());
                    this.docIds = new int[0];
                }

                @Override
                public float nextDocsAndScores(int upTo, Bits liveDocs, DocAndFloatFeatureBuffer buffer) throws IOException {
                    assert (upTo > 0);
                    if (this.matches.docID() == -1) {
                        this.matches.nextDoc();
                    }
                    buffer.growNoCopy(64);
                    this.docIds = ArrayUtil.growNoCopy(this.docIds, 64);
                    int size = 0;
                    int doc = this.matches.docID();
                    while (doc < upTo && size < 64) {
                        if (liveDocs == null || liveDocs.get(doc)) {
                            buffer.docs[size] = iterator.index();
                            this.docIds[size] = doc;
                            ++size;
                        }
                        doc = this.matches.nextDoc();
                    }
                    buffer.size = size;
                    float maxScore = scorer.bulkScore(buffer.docs, buffer.features, size);
                    System.arraycopy(this.docIds, 0, buffer.docs, 0, size);
                    return maxScore;
                }
            };
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

