/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsFormat;
import org.apache.lucene.search.DocAndScoreAccBuffer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterDocIdSetIterator;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.DenseLiveDocs;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.SparseLiveDocs;
import org.apache.lucene.util.VectorUtil;

class ScorerUtil {
    private static final Class<?> DEFAULT_IMPACTS_ENUM_CLASS = Lucene104PostingsFormat.getImpactsEnumImpl();
    private static final Class<?> DEFAULT_ACCEPT_DOCS_CLASS = new FixedBitSet(1).asReadOnlyBits().getClass();

    ScorerUtil() {
    }

    static long costWithMinShouldMatch(LongStream costs, int numScorers, int minShouldMatch) {
        PriorityQueue<Long> pq = new PriorityQueue<Long>(numScorers - minShouldMatch + 1){

            @Override
            protected boolean lessThan(Long a, Long b) {
                return a > b;
            }
        };
        costs.forEach(pq::insertWithOverflow);
        return StreamSupport.stream(pq.spliterator(), false).mapToLong(Number::longValue).sum();
    }

    static DocIdSetIterator likelyImpactsEnum(DocIdSetIterator it) {
        if (it.getClass() != DEFAULT_IMPACTS_ENUM_CLASS && it.getClass() != FilterDocIdSetIterator.class) {
            it = new FilterDocIdSetIterator(it);
        }
        return it;
    }

    static Scorable likelyTermScorer(Scorable scorable) {
        if (scorable.getClass() != TermScorer.class && scorable.getClass() != FilterScorable.class) {
            scorable = new FilterScorable(scorable);
        }
        return scorable;
    }

    static Bits likelyLiveDocs(Bits acceptDocs) {
        if (acceptDocs == null) {
            return acceptDocs;
        }
        if (acceptDocs.getClass() == DEFAULT_ACCEPT_DOCS_CLASS) {
            return acceptDocs;
        }
        if (acceptDocs instanceof SparseLiveDocs || acceptDocs instanceof DenseLiveDocs) {
            return acceptDocs;
        }
        return new FilterBits(acceptDocs);
    }

    static double minRequiredScore(double maxRemainingScore, float minCompetitiveScore, int numScorers) {
        double minRequiredScore;
        double subtraction = Math.ulp(minCompetitiveScore);
        for (minRequiredScore = (double)minCompetitiveScore - maxRemainingScore; minRequiredScore > 0.0 && (float)MathUtil.sumUpperBound(minRequiredScore + maxRemainingScore, numScorers) >= minCompetitiveScore; minRequiredScore -= subtraction) {
        }
        return minRequiredScore;
    }

    static void filterCompetitiveHits(DocAndScoreAccBuffer buffer, double maxRemainingScore, float minCompetitiveScore, int numScorers) {
        double minRequiredScore = ScorerUtil.minRequiredScore(maxRemainingScore, minCompetitiveScore, numScorers);
        if (minRequiredScore <= 0.0) {
            return;
        }
        buffer.size = VectorUtil.filterByScore(buffer.docs, buffer.scores, minRequiredScore, buffer.size);
    }

    static void applyRequiredClause(DocAndScoreAccBuffer buffer, DocIdSetIterator iterator, Scorable scorable) throws IOException {
        int intersectionSize = 0;
        int curDoc = iterator.docID();
        for (int i = 0; i < buffer.size; ++i) {
            int targetDoc = buffer.docs[i];
            if (curDoc < targetDoc) {
                curDoc = iterator.advance(targetDoc);
            }
            if (curDoc != targetDoc) continue;
            buffer.docs[intersectionSize] = targetDoc;
            buffer.scores[intersectionSize] = buffer.scores[i] + (double)scorable.score();
            ++intersectionSize;
        }
        buffer.size = intersectionSize;
    }

    static void applyOptionalClause(DocAndScoreAccBuffer buffer, DocIdSetIterator iterator, Scorable scorable) throws IOException {
        int curDoc = iterator.docID();
        for (int i = 0; i < buffer.size; ++i) {
            int targetDoc = buffer.docs[i];
            if (curDoc < targetDoc) {
                curDoc = iterator.advance(targetDoc);
            }
            if (curDoc != targetDoc) continue;
            int n = i;
            buffer.scores[n] = buffer.scores[n] + (double)scorable.score();
        }
    }

    private static class FilterBits
    implements Bits {
        private final Bits in;

        FilterBits(Bits in) {
            this.in = in;
        }

        @Override
        public boolean get(int index) {
            return this.in.get(index);
        }

        @Override
        public int length() {
            return this.in.length();
        }
    }
}

