/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.DenseLiveDocs;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LiveDocs;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.SparseLiveDocs;

public final class Lucene90LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene90LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;
    private static final double SPARSE_DENSE_THRESHOLD = 0.01;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        block11: {
            long gen = info.getDelGen();
            String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
            int maxDoc = info.info.maxDoc();
            int delCount = info.getDelCount();
            double deletionRate = (double)delCount / (double)maxDoc;
            try (ChecksumIndexInput input = dir.openChecksumInput(name);){
                Bits bits;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, info.info.getId(), Long.toString(gen, 36));
                    bits = this.readLiveDocs(input, maxDoc, deletionRate, delCount);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter(input, priorE);
                        throw throwable;
                    }
                    CodecUtil.checkFooter(input, priorE);
                    break block11;
                }
                CodecUtil.checkFooter(input, priorE);
                return bits;
            }
        }
        throw new AssertionError();
    }

    private Bits readLiveDocs(IndexInput input, int maxDoc, double deletionRate, int expectedDelCount) throws IOException {
        LiveDocs liveDocs;
        int actualDelCount;
        if (deletionRate <= 0.01) {
            SparseFixedBitSet sparse = this.readSparseFixedBitSet(input, maxDoc);
            actualDelCount = sparse.cardinality();
            liveDocs = SparseLiveDocs.builder(sparse, maxDoc).withDeletedCount(actualDelCount).build();
        } else {
            FixedBitSet dense = this.readFixedBitSet(input, maxDoc);
            actualDelCount = maxDoc - dense.cardinality();
            liveDocs = DenseLiveDocs.builder(dense, maxDoc).withDeletedCount(actualDelCount).build();
        }
        if (actualDelCount != expectedDelCount) {
            throw new CorruptIndexException("bits.deleted=" + actualDelCount + " info.delcount=" + expectedDelCount, input);
        }
        return liveDocs;
    }

    private FixedBitSet readFixedBitSet(IndexInput input, int length) throws IOException {
        long[] data = new long[FixedBitSet.bits2words(length)];
        input.readLongs(data, 0, data.length);
        return new FixedBitSet(data, length);
    }

    private SparseFixedBitSet readSparseFixedBitSet(IndexInput input, int length) throws IOException {
        long[] data = new long[FixedBitSet.bits2words(length)];
        input.readLongs(data, 0, data.length);
        SparseFixedBitSet sparse = new SparseFixedBitSet(length);
        for (int wordIndex = 0; wordIndex < data.length; ++wordIndex) {
            long word = data[wordIndex];
            if (word == -1L) continue;
            int baseDocId = wordIndex << 6;
            int maxDocInWord = Math.min(baseDocId + 64, length);
            for (int docId = baseDocId; docId < maxDocInWord; ++docId) {
                int bitIndex = docId & 0x3F;
                if ((word & 1L << bitIndex) != 0L) continue;
                sparse.set(docId);
            }
        }
        return sparse;
    }

    @Override
    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        int delCount;
        long gen = info.getNextDelGen();
        String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
        try (IndexOutput output = dir.createOutput(name, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, info.info.getId(), Long.toString(gen, 36));
            delCount = this.writeBits(output, bits);
            CodecUtil.writeFooter(output);
        }
        if (delCount != info.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + delCount + " info.delcount=" + info.getDelCount() + " newdelcount=" + newDelCount, name);
        }
    }

    private int writeBits(IndexOutput output, Bits bits) throws IOException {
        int delCount = bits.length();
        FixedBitSet copy = new FixedBitSet(1024);
        for (int offset = 0; offset < bits.length(); offset += copy.length()) {
            int numBitsToCopy = Math.min(bits.length() - offset, copy.length());
            copy.set(0, copy.length());
            if (numBitsToCopy < copy.length()) {
                copy.clear(numBitsToCopy, copy.length());
            }
            bits.applyMask(copy, offset);
            delCount -= copy.cardinality();
            int longCount = FixedBitSet.bits2words(numBitsToCopy);
            for (int i = 0; i < longCount; ++i) {
                output.writeLong(copy.getBits()[i]);
            }
        }
        return delCount;
    }

    @Override
    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, info.getDelGen()));
        }
    }
}

