/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene104;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene104.QuantizedByteVectorValues;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.quantization.OptimizedScalarQuantizer;

public abstract class OffHeapScalarQuantizedVectorValues
extends QuantizedByteVectorValues {
    final int dimension;
    final int size;
    final VectorSimilarityFunction similarityFunction;
    final FlatVectorsScorer vectorsScorer;
    final IndexInput slice;
    final byte[] vectorValue;
    final ByteBuffer byteBuffer;
    final int byteSize;
    private int lastOrd = -1;
    final float[] correctiveValues;
    int quantizedComponentSum;
    final OptimizedScalarQuantizer quantizer;
    final Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding;
    final float[] centroid;
    final float centroidDp;
    final boolean isQuerySide;

    OffHeapScalarQuantizedVectorValues(int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
        this(false, dimension, size, centroid, centroidDp, quantizer, encoding, similarityFunction, vectorsScorer, slice);
    }

    OffHeapScalarQuantizedVectorValues(boolean isQuerySide, int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
        assert (!isQuerySide || encoding.isAsymmetric());
        this.isQuerySide = isQuerySide;
        this.dimension = dimension;
        this.size = size;
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
        this.slice = slice;
        this.centroid = centroid;
        this.centroidDp = centroidDp;
        this.correctiveValues = new float[3];
        this.encoding = encoding;
        int docPackedLength = isQuerySide ? encoding.getQueryPackedLength(dimension) : encoding.getDocPackedLength(dimension);
        this.byteSize = docPackedLength + 12 + 4;
        this.byteBuffer = ByteBuffer.allocate(docPackedLength);
        this.vectorValue = this.byteBuffer.array();
        this.quantizer = quantizer;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.vectorValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.vectorValue.length);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = this.slice.readInt();
        this.lastOrd = targetOrd;
        return this.vectorValue;
    }

    @Override
    public IndexInput getSlice() {
        return this.slice;
    }

    @Override
    public float getCentroidDP() {
        return this.centroidDp;
    }

    @Override
    public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.vectorValue.length);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = this.slice.readInt();
        return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
    }

    @Override
    public OptimizedScalarQuantizer getQuantizer() {
        return this.quantizer;
    }

    @Override
    public Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding getScalarEncoding() {
        return this.encoding;
    }

    @Override
    public float[] getCentroid() {
        return this.centroid;
    }

    @Override
    public int getVectorByteLength() {
        return this.vectorValue.length;
    }

    static void packNibbles(byte[] unpacked, byte[] packed) {
        assert (unpacked.length == packed.length * 2);
        for (int i = 0; i < packed.length; ++i) {
            int x = unpacked[i] << 4 | unpacked[packed.length + i];
            packed[i] = (byte)x;
        }
    }

    static void unpackNibbles(byte[] packed, byte[] unpacked) {
        assert (unpacked.length == packed.length * 2);
        for (int i = 0; i < packed.length; ++i) {
            unpacked[i] = (byte)(packed[i] >> 4 & 0xF);
            unpacked[packed.length + i] = (byte)(packed[i] & 0xF);
        }
    }

    static OffHeapScalarQuantizedVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, float[] centroid, float centroidDp, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        assert (centroid != null);
        IndexInput bytesSlice = vectorData.slice("quantized-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, centroid, centroidDp, quantizer, encoding, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, centroid, centroidDp, quantizer, encoding, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapScalarQuantizedVectorValues {
        EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, null, Float.NaN, null, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, similarityFunction, vectorsScorer, null);
            assert (!this.isQuerySide);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public DenseOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] target) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapScalarQuantizedVectorValues {
        DenseOffHeapVectorValues(int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, centroid, centroidDp, quantizer, encoding, similarityFunction, vectorsScorer, slice);
        }

        DenseOffHeapVectorValues(boolean isQuerySide, int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(isQuerySide, dimension, size, centroid, centroidDp, quantizer, encoding, similarityFunction, vectorsScorer, slice);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.isQuerySide, this.dimension, this.size, this.centroid, this.centroidDp, this.quantizer, this.encoding, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            assert (!this.isQuerySide);
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }

                @Override
                public VectorScorer.Bulk bulk(DocIdSetIterator matchingDocs) {
                    return VectorScorer.Bulk.fromRandomScorerDense(scorer, iterator, matchingDocs);
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapScalarQuantizedVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, float[] centroid, float centroidDp, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, centroid, centroidDp, quantizer, encoding, similarityFunction, vectorsScorer, slice);
            assert (!this.isQuerySide);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            assert (!this.isQuerySide);
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.centroid, this.centroidDp, this.quantizer, this.encoding, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator(this.disi);
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            assert (!this.isQuerySide);
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }

                @Override
                public VectorScorer.Bulk bulk(DocIdSetIterator matchingDocs) {
                    return VectorScorer.Bulk.fromRandomScorerSparse(scorer, iterator, matchingDocs);
                }
            };
        }
    }
}

