/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.util.SloppyMath;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1, warmups=1)
@Warmup(iterations=1, time=1)
@Measurement(iterations=3, time=2)
public class RectangleBenchmark {
    @Benchmark
    public Rectangle benchmarkFromPointDistanceSloppySin(ExecutionPlan plan) {
        return Rectangle.fromPointDistance((double)plan.latitude, (double)plan.longitude, (double)plan.radiusMeters);
    }

    @Benchmark
    public Rectangle benchmarkFromPointDistanceStandardSin(ExecutionPlan plan) {
        return RectangleBenchmark.fromPointDistanceStandardSin(plan.latitude, plan.longitude, plan.radiusMeters);
    }

    private static Rectangle fromPointDistanceStandardSin(double centerLat, double centerLon, double radiusMeters) {
        double maxLon;
        double minLon;
        GeoUtils.checkLatitude((double)centerLat);
        GeoUtils.checkLongitude((double)centerLon);
        double radLat = Math.toRadians(centerLat);
        double radLon = Math.toRadians(centerLon);
        double radDistance = (radiusMeters + 0.07) / 6371008.7714;
        double minLat = radLat - radDistance;
        double maxLat = radLat + radDistance;
        if (minLat > GeoUtils.MIN_LAT_RADIANS && maxLat < GeoUtils.MAX_LAT_RADIANS) {
            double deltaLon = SloppyMath.asin((double)(Math.sin(radDistance) / SloppyMath.cos((double)radLat)));
            minLon = radLon - deltaLon;
            if (minLon < GeoUtils.MIN_LON_RADIANS) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > GeoUtils.MAX_LON_RADIANS) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, GeoUtils.MIN_LAT_RADIANS);
            maxLat = Math.min(maxLat, GeoUtils.MAX_LAT_RADIANS);
            minLon = GeoUtils.MIN_LON_RADIANS;
            maxLon = GeoUtils.MAX_LON_RADIANS;
        }
        return new Rectangle(Math.toDegrees(minLat), Math.toDegrees(maxLat), Math.toDegrees(minLon), Math.toDegrees(maxLon));
    }

    @State(value=Scope.Benchmark)
    public static class ExecutionPlan {
        @Param(value={"0.0", "45.0", "89.0", "-45.0", "-89.0"})
        private double latitude;
        @Param(value={"0.0", "179.0", "-179.0", "90.0", "-90.0"})
        private double longitude;
        @Param(value={"100", "1000", "10000", "100000", "1000000"})
        private double radiusMeters;
    }
}

