/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.dto.documents;

import java.util.Objects;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.luke.app.desktop.util.NumericUtils;

public final class NewField {
    private boolean deleted;
    private String name;
    private Class<? extends IndexableField> type;
    private String value;
    private IndexableFieldType fieldType;
    private boolean stored;

    public static NewField newInstance() {
        NewField f = new NewField();
        f.deleted = false;
        f.name = "";
        f.type = TextField.class;
        f.value = "";
        f.fieldType = new TextField("", "", Field.Store.NO).fieldType();
        f.stored = f.fieldType.stored();
        return f;
    }

    private NewField() {
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean deletedProperty() {
        return this.deleted;
    }

    public void setDeleted(boolean value) {
        this.deleted = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public Class<? extends IndexableField> getTypeProperty() {
        return this.type;
    }

    public Class<? extends IndexableField> getType() {
        return this.type;
    }

    public void setType(Class<? extends IndexableField> type) {
        this.type = Objects.requireNonNull(type);
    }

    public void resetFieldType(Class<?> type) {
        if (type.equals(TextField.class)) {
            this.fieldType = new TextField("", "", Field.Store.NO).fieldType();
        } else if (type.equals(StringField.class)) {
            this.fieldType = new StringField("", "", Field.Store.NO).fieldType();
        } else if (type.equals(IntPoint.class)) {
            this.fieldType = new IntPoint("", NumericUtils.convertToIntArray(this.value, true)).fieldType();
        } else if (type.equals(LongPoint.class)) {
            this.fieldType = new LongPoint("", NumericUtils.convertToLongArray(this.value, true)).fieldType();
        } else if (type.equals(FloatPoint.class)) {
            this.fieldType = new FloatPoint("", NumericUtils.convertToFloatArray(this.value, true)).fieldType();
        } else if (type.equals(DoublePoint.class)) {
            this.fieldType = new DoublePoint("", NumericUtils.convertToDoubleArray(this.value, true)).fieldType();
        } else if (type.equals(SortedDocValuesField.class)) {
            this.fieldType = new SortedDocValuesField("", null).fieldType();
        } else if (type.equals(SortedSetDocValuesField.class)) {
            this.fieldType = new SortedSetDocValuesField("", null).fieldType();
        } else if (type.equals(NumericDocValuesField.class)) {
            this.fieldType = new NumericDocValuesField("", 0L).fieldType();
        } else if (type.equals(SortedNumericDocValuesField.class)) {
            this.fieldType = new SortedNumericDocValuesField("", 0L).fieldType();
        } else if (type.equals(StoredField.class)) {
            this.fieldType = new StoredField("", "").fieldType();
        } else if (type.equals(Field.class)) {
            this.fieldType = new FieldType(this.fieldType);
        }
    }

    public IndexableFieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isStored() {
        return this.stored;
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = Objects.requireNonNull(value);
    }
}

