/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.configuration.conf;

public class AcrossClusterRuleKeys {

  public static final String KEY_CROSS_QUEUE = "crossQueue";

  public static final String KEY_PRIORITY_CLUSTER = "priorityCluster";

  public static final String KEY_START_TIME = "startTime";

  public static final String KEY_END_TIME = "endTime";

  public static final String KEY_TARGET_CPU_THRESHOLD = "targetCPUThreshold";

  public static final String KEY_TARGET_MEMORY_THRESHOLD = "targetMemoryThreshold";

  public static final String KEY_TARGET_CPU_PERCENTAGE_THRESHOLD = "targetCPUPercentageThreshold";

  public static final String KEY_TARGET_MEMORY_PERCENTAGE_THRESHOLD =
      "targetMemoryPercentageThreshold";

  public static final String KEY_ORIGIN_CPU_PERCENTAGE_THRESHOLD = "originCPUPercentageThreshold";

  public static final String KEY_ORIGIN_MEMORY_PERCENTAGE_THRESHOLD =
      "originMemoryPercentageThreshold";

  public static final String KEY_QUEUE_RULE = "queueRule";

  public static final String KEY_TIME_RULE = "timeRule";

  public static final String KEY_TARGET_CLUSTER_RULE = "targetClusterRule";

  public static final String KEY_ORIGIN_CLUSTER_RULE = "originClusterRule";

  public static final String KEY_PRIORITY_CLUSTER_RULE = "priorityClusterRule";
}
