/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GatewayServerClasspathExtender {
    private static final String CLASSPATH_PREPEND_PROPERTY = "gateway.server.prepend.classpath";
    private static final String CLASSPATH_APPEND_PROPERTY = "gateway.server.append.classpath";
    private static final String CLASSPATH_PREPEND_PROPERTY_PATTERN = "<property>\\s*<name>gateway.server.prepend.classpath</name>\\s*<value>(.*?)</value>\\s*</property>";
    private static final String CLASSPATH_APPEND_PROPERTY_PATTERN = "<property>\\s*<name>gateway.server.append.classpath</name>\\s*<value>(.*?)</value>\\s*</property>";
    private static final String CONFIG_FILE = "gateway-site.xml";
    private static final String CONFIG_PATH = "/../conf/";
    private static final String CLASS_PATH_PROPERTY = "class.path";
    private static final String MAIN_CLASS_PROPERTY = "main.class";
    private static final String GATEWAY_SERVER_MAIN_CLASS = "org.apache.knox.gateway.GatewayServer";
    private static final String[] CLASS_PATH_DELIMITERS = new String[]{",", ";"};
    private static final String KNOX_GATEWAY_CONF_DIR_VAR = "KNOX_GATEWAY_CONF_DIR";
    private final File base;
    private final Pattern prependPattern = Pattern.compile("<property>\\s*<name>gateway.server.prepend.classpath</name>\\s*<value>(.*?)</value>\\s*</property>", 32);
    private final Pattern appendPattern = Pattern.compile("<property>\\s*<name>gateway.server.append.classpath</name>\\s*<value>(.*?)</value>\\s*</property>", 32);

    public GatewayServerClasspathExtender(File base) {
        this.base = base;
    }

    public void extendClassPathProperty(Properties properties) throws IOException {
        Path configFilePath = this.getGatewayConfDir();
        if (GATEWAY_SERVER_MAIN_CLASS.equals(properties.getProperty(MAIN_CLASS_PROPERTY)) && Files.isReadable(configFilePath)) {
            String configContent = new String(Files.readAllBytes(configFilePath), StandardCharsets.UTF_8);
            this.prependClassPathProperty(configContent, properties);
            this.appendClassPathProperty(configContent, properties);
        }
    }

    private void prependClassPathProperty(String configContent, Properties properties) {
        String prepend = this.getPropertyFromConfigFile(this.prependPattern, configContent);
        if (prepend != null) {
            StringBuilder newClassPath = new StringBuilder(prepend);
            if (!this.endsWithDelimiter(newClassPath.toString())) {
                newClassPath.append(CLASS_PATH_DELIMITERS[1]);
            }
            newClassPath.append(properties.getProperty(CLASS_PATH_PROPERTY));
            properties.setProperty(CLASS_PATH_PROPERTY, newClassPath.toString());
        }
    }

    private void appendClassPathProperty(String configContent, Properties properties) {
        String appendage = this.getPropertyFromConfigFile(this.appendPattern, configContent);
        if (appendage != null) {
            StringBuilder newClassPath = new StringBuilder(properties.getProperty(CLASS_PATH_PROPERTY));
            if (!this.startsWithDelimiter(appendage)) {
                newClassPath.append(CLASS_PATH_DELIMITERS[1]);
            }
            newClassPath.append(appendage);
            properties.setProperty(CLASS_PATH_PROPERTY, newClassPath.toString());
        }
    }

    private String getPropertyFromConfigFile(Pattern pattern, String configContent) {
        String property = null;
        Matcher matcher = pattern.matcher(configContent);
        if (matcher.find() && !matcher.group(1).trim().isEmpty()) {
            property = matcher.group(1).trim();
        }
        return property;
    }

    private boolean endsWithDelimiter(String path) {
        return Arrays.stream(CLASS_PATH_DELIMITERS).anyMatch(path::endsWith);
    }

    private boolean startsWithDelimiter(String path) {
        return Arrays.stream(CLASS_PATH_DELIMITERS).anyMatch(path::startsWith);
    }

    private Path getGatewayConfDir() {
        String configDir = this.getVar(KNOX_GATEWAY_CONF_DIR_VAR, this.base.getPath() + CONFIG_PATH);
        return Paths.get(configDir, CONFIG_FILE);
    }

    private String getVar(String variableName, String defaultValue) {
        String value = System.getProperty(variableName);
        if (value == null) {
            value = System.getenv(variableName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

