/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

public final class DefaultExchange
implements ExtendedExchange {
    private final CamelContext context;
    private final long created;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>(8);
    private Message in;
    private Message out;
    private Exception exception;
    private String exchangeId;
    private UnitOfWork unitOfWork;
    private ExchangePattern pattern;
    private Endpoint fromEndpoint;
    private String fromRouteId;
    private List<Synchronization> onCompletions;
    private Boolean externalRedelivered;
    private String historyNodeId;
    private String historyNodeLabel;
    private boolean transacted;
    private boolean routeStop;
    private boolean rollbackOnly;
    private boolean rollbackOnlyLast;
    private boolean notifyEvent;
    private boolean interrupted;
    private boolean interruptable = true;
    private boolean redeliveryExhausted;
    private Boolean errorHandlerHandled;

    public DefaultExchange(CamelContext context) {
        this.context = context;
        this.pattern = ExchangePattern.InOnly;
        this.created = System.currentTimeMillis();
    }

    public DefaultExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
    }

    public DefaultExchange(Exchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.created = parent.getCreated();
        this.fromEndpoint = parent.getFromEndpoint();
        this.fromRouteId = parent.getFromRouteId();
        this.unitOfWork = parent.getUnitOfWork();
    }

    public DefaultExchange(Endpoint fromEndpoint) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = ExchangePattern.InOnly;
        this.created = System.currentTimeMillis();
        this.fromEndpoint = fromEndpoint;
    }

    public DefaultExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
        this.fromEndpoint = fromEndpoint;
    }

    public String toString() {
        if (this.exchangeId != null) {
            return "Exchange[" + this.exchangeId + "]";
        }
        return "Exchange[]";
    }

    public long getCreated() {
        return this.created;
    }

    public Exchange copy() {
        DefaultExchange exchange = new DefaultExchange((Exchange)this);
        exchange.setIn(this.getIn().copy());
        exchange.getIn().setBody(this.getIn().getBody());
        if (this.getIn().hasHeaders()) {
            exchange.getIn().setHeaders(this.safeCopyHeaders(this.getIn().getHeaders()));
        }
        if (this.hasOut()) {
            exchange.setOut(this.getOut().copy());
            exchange.getOut().setBody(this.getOut().getBody());
            if (this.getOut().hasHeaders()) {
                exchange.getOut().setHeaders(this.safeCopyHeaders(this.getOut().getHeaders()));
            }
        }
        exchange.setException(this.exception);
        exchange.setRouteStop(this.routeStop);
        exchange.setRollbackOnly(this.rollbackOnly);
        exchange.setRollbackOnlyLast(this.rollbackOnlyLast);
        exchange.setNotifyEvent(this.notifyEvent);
        exchange.setRedeliveryExhausted(this.redeliveryExhausted);
        exchange.setErrorHandlerHandled(this.errorHandlerHandled);
        if (this.hasProperties()) {
            this.safeCopyProperties(this.getProperties(), exchange.getProperties());
        }
        return exchange;
    }

    private Map<String, Object> safeCopyHeaders(Map<String, Object> headers) {
        ExtendedCamelContext ecc;
        HeadersMapFactory factory;
        if (headers == null) {
            return null;
        }
        if (this.context != null && (factory = (ecc = (ExtendedCamelContext)this.context).getHeadersMapFactory()) != null) {
            return factory.newMap(headers);
        }
        return new HashMap<String, Object>(headers);
    }

    private void safeCopyProperties(Map<String, Object> source, Map<String, Object> target) {
        List history;
        target.putAll(source);
        if (this.getContext().isMessageHistory().booleanValue() && (history = (List)target.remove("CamelMessageHistory")) != null) {
            target.put("CamelMessageHistory", new CopyOnWriteArrayList(history));
        }
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object answer = this.getProperty(name);
        return answer != null ? answer : defaultValue;
    }

    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }

    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType((Exchange)this, type, value);
    }

    public void setProperty(String name, Object value) {
        if (value != null) {
            this.properties.put(name, value);
        } else if (name != null) {
            this.properties.remove(name);
        }
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public Object removeProperty(String name) {
        if (!this.hasProperties()) {
            return null;
        }
        return this.properties.remove(name);
    }

    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    public boolean removeProperties(String pattern, String ... excludePatterns) {
        if (!this.hasProperties()) {
            return false;
        }
        HashSet<String> toBeRemoved = new HashSet<String>();
        boolean matches = false;
        for (String key : this.properties.keySet()) {
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            toBeRemoved.add(key);
        }
        if (!toBeRemoved.isEmpty()) {
            if (toBeRemoved.size() == this.properties.size()) {
                this.properties.clear();
            } else {
                toBeRemoved.forEach(k -> this.properties.remove(k));
            }
        }
        return matches;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)in);
    }

    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    public Message getOut() {
        if (this.out == null) {
            this.out = this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage(this.getContext());
            this.configureMessage(this.out);
        }
        return this.out;
    }

    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)out);
    }

    public boolean hasOut() {
        return this.out != null;
    }

    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    public <T> T getMessage(Class<T> type) {
        return this.hasOut() ? this.getOut(type) : this.getIn(type);
    }

    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public <T> T getException(Class<T> type) {
        return (T)ObjectHelper.getException(type, (Throwable)this.exception);
    }

    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : CamelExecutionException.wrapCamelExecutionException((Exchange)this, (Throwable)t));
        if (t instanceof InterruptedException) {
            this.setInterrupted(true);
        }
    }

    public <T extends Exchange> T adapt(Class<T> type) {
        return (T)((Exchange)type.cast(this));
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = true;
    }

    public boolean isRouteStop() {
        return this.routeStop;
    }

    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    public boolean isExternalRedelivered() {
        if (this.externalRedelivered == null) {
            Message msg = this.getIn();
            if (msg instanceof DefaultMessage) {
                this.externalRedelivered = ((DefaultMessage)msg).isTransactedRedelivered();
            }
            if (this.externalRedelivered == null) {
                this.externalRedelivered = false;
            }
        }
        return this.externalRedelivered;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.getUnitOfWork().addSynchronization(onCompletion);
        }
    }

    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                ((ExtendedExchange)target.adapt(ExtendedExchange.class)).addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    public String getHistoryNodeId() {
        return this.historyNodeId;
    }

    public void setHistoryNodeId(String historyNodeId) {
        this.historyNodeId = historyNodeId;
    }

    public String getHistoryNodeLabel() {
        return this.historyNodeLabel;
    }

    public void setHistoryNodeLabel(String historyNodeLabel) {
        this.historyNodeLabel = historyNodeLabel;
    }

    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        if (this.interruptable) {
            this.interrupted = interrupted;
        }
    }

    public void setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
    }

    public boolean isRedeliveryExhausted() {
        return this.redeliveryExhausted;
    }

    public void setRedeliveryExhausted(boolean redeliveryExhausted) {
        this.redeliveryExhausted = redeliveryExhausted;
    }

    public Boolean getErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    public boolean isErrorHandlerHandled() {
        return this.errorHandlerHandled != null && this.errorHandlerHandled != false;
    }

    public void setErrorHandlerHandled(Boolean errorHandlerHandled) {
        this.errorHandlerHandled = errorHandlerHandled;
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange((Exchange)this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateUuid();
    }
}

