/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPMetadata;
import org.apache.aries.jmx.blueprint.codec.BPNonNullMetadata;
import org.apache.aries.jmx.blueprint.codec.TransferObject;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;

public class BPMapEntry
implements TransferObject {
    private BPNonNullMetadata key;
    private BPMetadata value;

    public BPMapEntry(CompositeData entry) {
        Byte[] buf = (Byte[])entry.get("Key");
        this.key = (BPNonNullMetadata)Util.boxedBinary2BPMetadata(buf);
        buf = (Byte[])entry.get("Value");
        this.value = Util.boxedBinary2BPMetadata(buf);
    }

    public BPMapEntry(MapEntry entry) {
        this.key = (BPNonNullMetadata)Util.metadata2BPMetadata((Metadata)entry.getKey());
        this.value = Util.metadata2BPMetadata(entry.getValue());
    }

    @Override
    public CompositeData asCompositeData() {
        HashMap<String, Byte[]> items = new HashMap<String, Byte[]>();
        items.put("Key", Util.bpMetadata2BoxedBinary(this.key));
        items.put("Value", Util.bpMetadata2BoxedBinary(this.value));
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.MAP_ENTRY_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public BPNonNullMetadata getKey() {
        return this.key;
    }

    public BPMetadata getValue() {
        return this.value;
    }
}

