/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.parser.ComponentDefinitionRegistryImpl;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.apache.aries.blueprint.parser.Parser;
import org.apache.aries.blueprint.services.ParserService;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class ParserServiceImpl
implements ParserService {
    final NamespaceHandlerRegistry _namespaceHandlerRegistry;
    final boolean _ignoreUnknownNamespaceHandlers;

    public ParserServiceImpl(NamespaceHandlerRegistry nhr, boolean ignoreUnknownNamespaceHandlers) {
        this._namespaceHandlerRegistry = nhr;
        this._ignoreUnknownNamespaceHandlers = ignoreUnknownNamespaceHandlers;
    }

    @Override
    public ComponentDefinitionRegistry parse(URL url, Bundle clientBundle) throws Exception {
        return this.parse(url, clientBundle, false);
    }

    @Override
    public ComponentDefinitionRegistry parse(URL url, Bundle clientBundle, boolean validate) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(url);
        return this.parse(urls, clientBundle, validate);
    }

    @Override
    public ComponentDefinitionRegistry parse(List<URL> urls, Bundle clientBundle) throws Exception {
        return this.parse(urls, clientBundle, false);
    }

    @Override
    public ComponentDefinitionRegistry parse(List<URL> urls, Bundle clientBundle, boolean validate) throws Exception {
        Parser parser = new Parser(null, this._ignoreUnknownNamespaceHandlers);
        parser.parse(urls);
        return this.validateAndPopulate(parser, clientBundle, validate);
    }

    @Override
    public ComponentDefinitionRegistry parse(InputStream is, Bundle clientBundle) throws Exception {
        return this.parse(is, clientBundle, false);
    }

    @Override
    public ComponentDefinitionRegistry parse(InputStream is, Bundle clientBundle, boolean validate) throws Exception {
        Parser parser = new Parser(null, this._ignoreUnknownNamespaceHandlers);
        parser.parse(is);
        return this.validateAndPopulate(parser, clientBundle, validate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentDefinitionRegistry validateAndPopulate(Parser parser, Bundle clientBundle, boolean validate) throws IOException, SAXException {
        ComponentDefinitionRegistryImpl cdr;
        Set<URI> nsuris = parser.getNamespaces();
        NamespaceHandlerSet nshandlers = this._namespaceHandlerRegistry.getNamespaceHandlers(nsuris, clientBundle);
        try {
            if (validate) {
                parser.validate(nshandlers.getSchema());
            }
            cdr = new ComponentDefinitionRegistryImpl();
            parser.populate(nshandlers, cdr);
        }
        finally {
            nshandlers.destroy();
        }
        return cdr;
    }
}

