/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.ontapi.OntModelFactory;
import org.apache.jena.ontapi.OntSpecification;
import org.apache.jena.ontapi.assemblers.OA;
import org.apache.jena.ontapi.impl.repositories.DocumentGraphRepository;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class OntModelAssembler
extends AssemblerBase {
    public Object open(Assembler a, Resource root, Mode mode) {
        this.checkType(root, OA.OntModel);
        Model baseModel = this.getBase(a, root, mode);
        OntSpecification specification = this.getOntModelSpec(a, root);
        DocumentGraphRepository graphRepository = this.getDocumentGraphRepositoryOrNull(a, root);
        OntModel res = graphRepository == null ? OntModelFactory.createModel(baseModel.getGraph(), specification) : OntModelFactory.createModel(baseModel.getGraph(), specification, graphRepository);
        root.listProperties(OA.importModels).mapWith(Statement::getResource).mapWith(resource -> {
            this.checkType((Resource)resource, OA.OntModel);
            return (OntModel)a.open(resource);
        }).forEach(res::addImport);
        return res;
    }

    private Model getBase(Assembler a, Resource root, Mode mode) {
        Resource base = OntModelAssembler.getUniqueResource((Resource)root, (Property)OA.baseModel);
        return base == null ? ModelFactory.createDefaultModel() : a.openModel(base, mode);
    }

    private OntSpecification getOntModelSpec(Assembler a, Resource root) {
        Resource r = OntModelAssembler.getUniqueResource((Resource)root, (Property)OA.ontModelSpec);
        return r == null ? OntSpecification.OWL2_DL_MEM_BUILTIN_RDFS_INF : (OntSpecification)a.open(r);
    }

    private DocumentGraphRepository getDocumentGraphRepositoryOrNull(Assembler a, Resource root) {
        Resource r = OntModelAssembler.getUniqueResource((Resource)root, (Property)OA.documentGraphRepository);
        return r == null ? null : (DocumentGraphRepository)a.open(r);
    }
}

