/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.turtlejcc;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.turtlejcc.OutputRDF;
import org.apache.jena.riot.lang.turtlejcc.javacc.ParseException;
import org.apache.jena.riot.lang.turtlejcc.javacc.TokenMgrError;
import org.apache.jena.riot.lang.turtlejcc.javacc.TurtleJavacc;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class TurtleJavaccReaderRIOT
implements ReaderRIOT {
    private final ParserProfile profile;

    public TurtleJavaccReaderRIOT(ParserProfile profile) {
        this.profile = profile;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF streamDest, Context context2) {
        BufferedReader r = IO.asBufferedUTF8((InputStream)in);
        TurtleJavacc parser = new TurtleJavacc(r);
        this.read(parser, baseURI, ct, streamDest, context2);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        TurtleJavacc parser = new TurtleJavacc(reader);
        this.read(parser, baseURI, ct, output, context2);
    }

    private void read(TurtleJavacc parser, String baseURI, ContentType ct, StreamRDF streamDest, Context context2) {
        StreamRDFJCC output = new StreamRDFJCC(streamDest);
        parser.setDest(output);
        parser.setProfile(this.profile);
        try {
            output.start();
            parser.parse();
            output.finish();
        }
        catch (ParseException ex) {
            this.profile.getErrorHandler().error(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
            throw new RiotParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError ex) {
            this.profile.getErrorHandler().error(ex.getMessage(), -1L, -1L);
            throw new RiotParseException(ex.getMessage(), -1L, -1L);
        }
    }

    static class StreamRDFJCC
    implements OutputRDF {
        private final StreamRDF dest;

        StreamRDFJCC(StreamRDF dest) {
            this.dest = dest;
        }

        @Override
        public void start() {
            this.dest.start();
        }

        @Override
        public void triple(Triple triple) {
            this.dest.triple(triple);
        }

        @Override
        public void quad(Quad quad) {
            this.dest.quad(quad);
        }

        @Override
        public void base(String base) {
            this.dest.base(base);
        }

        @Override
        public void prefix(String prefix, String iri) {
            this.dest.prefix(prefix, iri);
        }

        @Override
        public void version(String version2) {
            this.dest.version(version2);
        }

        @Override
        public void finish() {
            this.dest.finish();
        }
    }
}

