/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.optimize.VariableUsageTracker;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.Vars;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVars;

public abstract class VariableUsageVisitor
extends OpVisitorBase {
    protected VariableUsageTracker tracker;

    public VariableUsageVisitor(VariableUsageTracker tracker) {
        this.tracker = tracker;
    }

    protected abstract void action(Collection<Var> var1);

    protected abstract void action(Var var1);

    protected abstract void action(String var1);

    @Override
    public void visit(OpBGP opBGP) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Triple t : opBGP.getPattern().getList()) {
            Vars.addVarsFromTriple(vars, t);
        }
        this.action(vars);
    }

    @Override
    public void visit(OpQuadPattern quadPattern) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Quad q : quadPattern.getPattern().getList()) {
            Vars.addVarsFromQuad(vars, q);
        }
        this.action(vars);
    }

    @Override
    public void visit(OpQuadBlock quadBlock) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Quad q : quadBlock.getPattern().getList()) {
            Vars.addVarsFromQuad(vars, q);
        }
        this.action(vars);
    }

    @Override
    public void visit(OpPath opPath) {
        if (opPath.getTriplePath().getSubject().isVariable()) {
            this.action(opPath.getTriplePath().getSubject().getName());
        }
        if (opPath.getTriplePath().getObject().isVariable()) {
            this.action(opPath.getTriplePath().getObject().getName());
        }
    }

    @Override
    public void visit(OpPropFunc opPropFunc) {
        for (Node subjArg : opPropFunc.getSubjectArgs().getArgList()) {
            if (!subjArg.isVariable()) continue;
            this.action(subjArg.getName());
        }
        for (Node objArg : opPropFunc.getObjectArgs().getArgList()) {
            if (!objArg.isVariable()) continue;
            this.action(objArg.getName());
        }
    }

    @Override
    public void visit(OpLeftJoin opLeftJoin) {
        ArrayList<Var> vars = new ArrayList<Var>();
        if (opLeftJoin.getExprs() != null) {
            for (Expr expr : opLeftJoin.getExprs().getList()) {
                ExprVars.varsMentioned(vars, expr);
            }
        }
        this.action(vars);
    }

    @Override
    public void visit(OpFilter opFilter) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Expr expr : opFilter.getExprs().getList()) {
            ExprVars.varsMentioned(vars, expr);
        }
        this.action(vars);
    }

    @Override
    public void visit(OpGraph opGraph) {
        if (opGraph.getNode().isVariable()) {
            this.action(opGraph.getNode().getName());
        }
    }

    @Override
    public void visit(OpDatasetNames dsNames) {
        if (dsNames.getGraphNode().isVariable()) {
            this.action(dsNames.getGraphNode().getName());
        }
    }

    @Override
    public void visit(OpTable opTable) {
        this.action(opTable.getTable().getVars());
    }

    @Override
    public void visit(OpAssign opAssign) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Var var : opAssign.getVarExprList().getVars()) {
            vars.add(var);
            ExprVars.varsMentioned(vars, opAssign.getVarExprList().getExpr(var));
        }
        this.action(vars);
    }

    @Override
    public void visit(OpExtend opExtend) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Var var : opExtend.getVarExprList().getVars()) {
            vars.add(var);
            ExprVars.varsMentioned(vars, opExtend.getVarExprList().getExpr(var));
        }
        this.action(vars);
    }

    @Override
    public void visit(OpUnfold opUnfold) {
        ArrayList<Var> vars = new ArrayList<Var>();
        ExprVars.varsMentioned(vars, opUnfold.getExpr());
        vars.add(opUnfold.getVar1());
        if (opUnfold.getVar2() != null) {
            vars.add(opUnfold.getVar2());
        }
        this.action(vars);
    }

    @Override
    public void visit(OpOrder opOrder) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (SortCondition condition : opOrder.getConditions()) {
            ExprVars.varsMentioned(vars, condition);
        }
        this.action(vars);
    }

    @Override
    public void visit(OpProject opProject) {
        for (Var var : opProject.getVars()) {
            this.action(var);
        }
    }

    @Override
    public void visit(OpGroup opGroup) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Var var : opGroup.getGroupVars().getVars()) {
            vars.add(var);
            ExprVars.varsMentioned(vars, opGroup.getGroupVars().getExpr(var));
        }
    }

    @Override
    public void visit(OpTopN opTop) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (SortCondition condition : opTop.getConditions()) {
            ExprVars.varsMentioned(vars, condition);
        }
        this.action(vars);
    }
}

