/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.util.BufferRecycler;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteArrayOutputStreamRecycler;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.CharsetUtil;

public class ContentUtil {
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected static final ThreadLocal<SoftReference<ByteArrayOutputStreamRecycler>> _outputStreamRecyclerRef = new ThreadLocal();
    static final int DEFAULT_COPY_BUFFER_SIZE = 4096;

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            ref = new SoftReference<BufferRecycler>(br);
            _recyclerRef.set(ref);
        }
        return br;
    }

    public static ByteArrayOutputStreamRecycler getOutputStreamRecycler() {
        ByteArrayOutputStreamRecycler br;
        SoftReference<ByteArrayOutputStreamRecycler> ref = _outputStreamRecyclerRef.get();
        ByteArrayOutputStreamRecycler byteArrayOutputStreamRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new ByteArrayOutputStreamRecycler();
            ref = new SoftReference<ByteArrayOutputStreamRecycler>(br);
            _outputStreamRecyclerRef.set(ref);
        }
        return br;
    }

    private ContentUtil() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int inputLength;
        BufferRecycler bufferRecycler = ContentUtil.getBufferRecycler();
        byte[] buffer = bufferRecycler.allocByteBuffer(0, 4096);
        while (-1 != (inputLength = in.read(buffer))) {
            out.write(buffer, 0, inputLength);
        }
        bufferRecycler.releaseByteBuffer(0, buffer);
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int inputLength;
        BufferRecycler bufferRecycler = ContentUtil.getBufferRecycler();
        char[] buffer = bufferRecycler.allocCharBuffer(0, 4096);
        while (-1 != (inputLength = in.read(buffer))) {
            out.write(buffer, 0, inputLength);
        }
        bufferRecycler.releaseCharBuffer(0, buffer);
    }

    public static byte[] buffer(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        UnsynchronizedByteArrayOutputStream buf = new UnsynchronizedByteArrayOutputStream();
        ContentUtil.copy(in, buf);
        return buf.toByteArray();
    }

    public static ByteArrayOutputStreamRecycler.Wrapper bufferEfficient(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        ByteArrayOutputStreamRecycler.Wrapper buf = ContentUtil.getOutputStreamRecycler().allocOutputStream();
        ContentUtil.copy(in, buf.getValue());
        return buf;
    }

    public static String buffer(Reader in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        StringWriter buf = new StringWriter();
        ContentUtil.copy(in, buf);
        return buf.toString();
    }

    public static ByteSequence encode(CharSequence string) {
        if (string == null) {
            return null;
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            buf.append((byte)string.charAt(i));
        }
        return buf;
    }

    public static ByteSequence encode(Charset charset, CharSequence string) {
        if (string == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        ByteBuffer encoded = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer buf = new ByteArrayBuffer(encoded.remaining());
        buf.append(encoded.array(), encoded.position(), encoded.remaining());
        return buf;
    }

    public static String decode(ByteSequence byteSequence) {
        if (byteSequence == null) {
            return null;
        }
        return ContentUtil.decode(byteSequence, 0, byteSequence.length());
    }

    public static String decode(Charset charset, ByteSequence byteSequence) {
        return ContentUtil.decode(charset, byteSequence, 0, byteSequence.length());
    }

    public static String decode(ByteSequence byteSequence, int offset, int length) {
        if (byteSequence == null) {
            return null;
        }
        char[] underlying = new char[length];
        for (int i = offset; i < offset + length; ++i) {
            underlying[i - offset] = (char)(byteSequence.byteAt(i) & 0xFF);
        }
        return new String(underlying);
    }

    public static String decode(ByteSequence byteSequence, int offset, int length, Charset charset) {
        if (byteSequence == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int i = offset; i < offset + length; ++i) {
            char ch = (char)(byteSequence.byteAt(i) & 0xFF);
            if (!CharsetUtil.isASCII(ch)) {
                return ContentUtil.decode(charset, byteSequence, offset, length);
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String decode(Charset charset, ByteSequence byteSequence, int offset, int length) {
        if (byteSequence == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (byteSequence instanceof ByteArrayBuffer) {
            ByteArrayBuffer bab = (ByteArrayBuffer)byteSequence;
            return ContentUtil.decode(charset, bab.buffer(), offset, length);
        }
        byte[] bytes = byteSequence.toByteArray();
        return ContentUtil.decode(charset, bytes, offset, length);
    }

    private static String decode(Charset charset, byte[] buffer, int offset, int length) {
        return charset.decode(ByteBuffer.wrap(buffer, offset, length)).toString();
    }

    public static byte[] toByteArray(String s2, Charset charset) {
        if (s2 == null) {
            return null;
        }
        try {
            return s2.getBytes((charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static byte[] toAsciiByteArray(String s2) {
        return ContentUtil.toByteArray(s2, Charsets.US_ASCII);
    }

    public static String toString(byte[] b, Charset charset) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, (charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String toAsciiString(byte[] b) {
        return ContentUtil.toString(b, Charsets.US_ASCII);
    }

    public static String toString(byte[] b, int off, int len, Charset charset) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b, off, len, (charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String toAsciiString(byte[] b, int off, int len) {
        return ContentUtil.toString(b, off, len, Charsets.US_ASCII);
    }

    public static String toString(ByteArrayBuffer b, Charset charset) {
        if (b == null) {
            return null;
        }
        try {
            return new String(b.buffer(), 0, b.length(), (charset != null ? charset : Charsets.DEFAULT_CHARSET).name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String toAsciiString(ByteArrayBuffer b) {
        return ContentUtil.toString(b, Charsets.US_ASCII);
    }
}

