/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.search;

import java.util.function.Predicate;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.search.DeletedMessageField;
import org.apache.james.vault.search.Operator;

public class Criterion<T> {
    private static final boolean DEFAULT_TO_NON_MATCHED_IF_NON_EXIST = false;
    private final DeletedMessageField<T> field;
    private final ValueMatcher<?, T> valueMatcher;

    private Criterion(DeletedMessageField<T> field, ValueMatcher<?, T> valueMatcher) {
        this.field = field;
        this.valueMatcher = valueMatcher;
    }

    Predicate<DeletedMessage> toPredicate() {
        return deletedMessage -> this.field.valueExtractor().extract((DeletedMessage)deletedMessage).map(this.valueMatcher::matches).orElse(false);
    }

    public DeletedMessageField<T> getField() {
        return this.field;
    }

    public ValueMatcher<?, T> getValueMatcher() {
        return this.valueMatcher;
    }

    public static interface Builder {
        public static <U> ExpectMatcher<U> forField(DeletedMessageField<U> field) {
            return matcher -> new Criterion(field, matcher);
        }
    }

    public static interface ExpectMatcher<T> {
        public Criterion<T> withMatcher(ValueMatcher<?, T> var1);
    }

    public static class ValueMatcher<V, T> {
        private V expectedValue;
        private Operator operator;
        private Predicate<T> matchPredicate;

        public ValueMatcher(V expectedValue, Operator operator, Predicate<T> matchPredicate) {
            this.expectedValue = expectedValue;
            this.operator = operator;
            this.matchPredicate = matchPredicate;
        }

        public V expectedValue() {
            return this.expectedValue;
        }

        public Operator operator() {
            return this.operator;
        }

        public boolean matches(T value) {
            return this.matchPredicate.test(value);
        }
    }
}

