/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq.metric;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.james.metrics.api.GaugeRegistry;

public class ActiveMQMetrics {
    private static final String TEMP_PERCENT_USAGE = "tempPercentUsage";
    private static final String STORE_PERCENT_USAGE = "storePercentUsage";
    private static final String MEMORY_PERCENT_USAGE = "memoryPercentUsage";
    private static final String MEMORY_LIMIT = "memoryLimit";
    private static final String STORE_LIMIT = "storeLimit";
    private static final String TEMP_LIMIT = "tempLimit";
    private static final String MEMORY_USAGE = "memoryUsage";
    private static final String STORE_USAGE = "storeUsage";
    private static final String TEMP_USAGE = "tempUsage";
    private static final String SIZE = "size";
    private static final String ENQUEUE_COUNT = "enqueueCount";
    private static final String DEQUEUE_COUNT = "dequeueCount";
    private static final String INFLIGHT_COUNT = "inflightCount";
    private static final String PRODUCER_COUNT = "producerCount";
    private static final String CONSUMER_COUNT = "consumerCount";
    private static final String EXPIRED_COUNT = "expiredCount";
    private static final String DISPATCH_COUNT = "dispatchCount";
    private static final String MESSAGES_CACHED = "messagesCached";
    private static final String MIN_ENQUEUE_TIME = "minEnqueueTime";
    private static final String MAX_ENQUEUE_TIME = "maxEnqueueTime";
    private static final String AVERAGE_ENQUEUE_TIME = "averageEnqueueTime";
    private static final String LAST_UPDATE = "lastUpdate";
    private final String statsQueueName;
    private final GaugeRegistry gaugeRegistry;
    private final Map<String, GaugeRegistry.SettableGauge<Integer>> registeredGaugesOfInteger = new HashMap<String, GaugeRegistry.SettableGauge<Integer>>();
    private final Map<String, GaugeRegistry.SettableGauge<Double>> registeredGaugesOfDouble = new HashMap<String, GaugeRegistry.SettableGauge<Double>>();
    private final Map<String, GaugeRegistry.SettableGauge<Long>> registeredGaugesOfLong = new HashMap<String, GaugeRegistry.SettableGauge<Long>>();

    public static ActiveMQMetrics forQueue(String queueName, GaugeRegistry gaugeRegistry) {
        return new ActiveMQMetrics("ActiveMQ.Statistics.Destination." + queueName, gaugeRegistry);
    }

    public static ActiveMQMetrics forBroker(GaugeRegistry gaugeRegistry) {
        return new ActiveMQMetrics("ActiveMQ.Statistics.Broker", gaugeRegistry);
    }

    private ActiveMQMetrics(String statsQueueName, GaugeRegistry gaugeRegistry) {
        this.statsQueueName = statsQueueName;
        this.gaugeRegistry = gaugeRegistry;
    }

    public String getName() {
        return this.statsQueueName;
    }

    public void updateMetrics(MapMessage msg) throws JMSException {
        if (msg.itemExists(MEMORY_PERCENT_USAGE)) {
            this.setGaugeAndRegisterIfAbsent(MEMORY_PERCENT_USAGE, msg.getInt(MEMORY_PERCENT_USAGE));
        }
        if (msg.itemExists(STORE_PERCENT_USAGE)) {
            this.setGaugeAndRegisterIfAbsent(TEMP_PERCENT_USAGE, msg.getInt(STORE_PERCENT_USAGE));
        }
        if (msg.itemExists(TEMP_PERCENT_USAGE)) {
            this.setGaugeAndRegisterIfAbsent(TEMP_PERCENT_USAGE, msg.getInt(TEMP_PERCENT_USAGE));
        }
        if (msg.itemExists(MEMORY_LIMIT)) {
            this.setGaugeAndRegisterIfAbsent(MEMORY_LIMIT, msg.getLong(MEMORY_LIMIT));
        }
        if (msg.itemExists(STORE_LIMIT)) {
            this.setGaugeAndRegisterIfAbsent(STORE_LIMIT, msg.getLong(STORE_LIMIT));
        }
        if (msg.itemExists(TEMP_LIMIT)) {
            this.setGaugeAndRegisterIfAbsent(TEMP_LIMIT, msg.getLong(TEMP_LIMIT));
        }
        if (msg.itemExists(MEMORY_USAGE)) {
            this.setGaugeAndRegisterIfAbsent(MEMORY_USAGE, msg.getLong(MEMORY_USAGE));
        }
        if (msg.itemExists(STORE_USAGE)) {
            this.setGaugeAndRegisterIfAbsent(STORE_USAGE, msg.getLong(STORE_USAGE));
        }
        if (msg.itemExists(TEMP_USAGE)) {
            this.setGaugeAndRegisterIfAbsent(TEMP_USAGE, msg.getLong(TEMP_USAGE));
        }
        if (msg.itemExists(SIZE)) {
            this.setGaugeAndRegisterIfAbsent(SIZE, msg.getLong(SIZE));
        }
        if (msg.itemExists(ENQUEUE_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(ENQUEUE_COUNT, msg.getLong(ENQUEUE_COUNT));
        }
        if (msg.itemExists(DEQUEUE_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(DEQUEUE_COUNT, msg.getLong(DEQUEUE_COUNT));
        }
        if (msg.itemExists(INFLIGHT_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(INFLIGHT_COUNT, msg.getLong(INFLIGHT_COUNT));
        }
        if (msg.itemExists(PRODUCER_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(PRODUCER_COUNT, msg.getLong(PRODUCER_COUNT));
        }
        if (msg.itemExists(CONSUMER_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(CONSUMER_COUNT, msg.getLong(CONSUMER_COUNT));
        }
        if (msg.itemExists(EXPIRED_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(EXPIRED_COUNT, msg.getLong(EXPIRED_COUNT));
        }
        if (msg.itemExists(DISPATCH_COUNT)) {
            this.setGaugeAndRegisterIfAbsent(DISPATCH_COUNT, msg.getLong(DISPATCH_COUNT));
        }
        if (msg.itemExists(MESSAGES_CACHED)) {
            this.setGaugeAndRegisterIfAbsent(MESSAGES_CACHED, msg.getLong(MESSAGES_CACHED));
        }
        if (msg.itemExists(MIN_ENQUEUE_TIME)) {
            this.setGaugeAndRegisterIfAbsent(MIN_ENQUEUE_TIME, msg.getDouble(MIN_ENQUEUE_TIME));
        }
        if (msg.itemExists(MAX_ENQUEUE_TIME)) {
            this.setGaugeAndRegisterIfAbsent(MAX_ENQUEUE_TIME, msg.getDouble(MAX_ENQUEUE_TIME));
        }
        if (msg.itemExists(AVERAGE_ENQUEUE_TIME)) {
            this.setGaugeAndRegisterIfAbsent(AVERAGE_ENQUEUE_TIME, msg.getDouble(AVERAGE_ENQUEUE_TIME));
        }
        this.setGaugeAndRegisterIfAbsent(LAST_UPDATE, System.currentTimeMillis());
    }

    private void setGaugeAndRegisterIfAbsent(String name, long val) {
        String key = this.statsQueueName + "." + name;
        this.registeredGaugesOfLong.computeIfAbsent(key, any -> this.gaugeRegistry.settableGauge(key)).setValue((Object)val);
    }

    private void setGaugeAndRegisterIfAbsent(String name, int val) {
        String key = this.statsQueueName + "." + name;
        this.registeredGaugesOfInteger.computeIfAbsent(key, any -> this.gaugeRegistry.settableGauge(key)).setValue((Object)val);
    }

    private void setGaugeAndRegisterIfAbsent(String name, double val) {
        String key = this.statsQueueName + "." + name;
        this.registeredGaugesOfDouble.computeIfAbsent(key, any -> this.gaugeRegistry.settableGauge(key)).setValue((Object)val);
    }
}

