/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.recovery.FileDetails;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RecoveryFiles
implements JsonpSerializable {
    private final List<FileDetails> details;
    private final String percent;
    private final long recovered;
    private final long reused;
    private final long total;
    public static final JsonpDeserializer<RecoveryFiles> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryFiles::setupRecoveryFilesDeserializer);

    private RecoveryFiles(Builder builder) {
        this.details = ApiTypeHelper.unmodifiable(builder.details);
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.recovered = ApiTypeHelper.requireNonNull(builder.recovered, this, "recovered");
        this.reused = ApiTypeHelper.requireNonNull(builder.reused, this, "reused");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static RecoveryFiles of(Function<Builder, ObjectBuilder<RecoveryFiles>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FileDetails> details() {
        return this.details;
    }

    public final String percent() {
        return this.percent;
    }

    public final long recovered() {
        return this.recovered;
    }

    public final long reused() {
        return this.reused;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (FileDetails item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("reused");
        generator.write(this.reused);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static void setupRecoveryFilesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(FileDetails._DESERIALIZER), "details");
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent");
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered");
        op.add(Builder::reused, JsonpDeserializer.longDeserializer(), "reused");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RecoveryFiles> {
        @Nullable
        private List<FileDetails> details;
        private String percent;
        private Long recovered;
        private Long reused;
        private Long total;

        public final Builder details(List<FileDetails> list) {
            this.details = Builder._listAddAll(this.details, list);
            return this;
        }

        public final Builder details(FileDetails value, FileDetails ... values) {
            this.details = Builder._listAdd(this.details, value, values);
            return this;
        }

        public final Builder details(Function<FileDetails.Builder, ObjectBuilder<FileDetails>> fn) {
            return this.details(fn.apply(new FileDetails.Builder()).build(), new FileDetails[0]);
        }

        public final Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public final Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        public final Builder reused(long value) {
            this.reused = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        public RecoveryFiles build() {
            this._checkSingleUse();
            return new RecoveryFiles(this);
        }
    }
}

