/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.PingMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.EventSourceOptions;
import org.apache.james.jmap.routes.EventSourceOptionsFactory;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\b\u0011\u0001mA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ!\u0005\u0001\u0005BIDQA \u0001\u0005\n}Dq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m&!E#wK:$8k\\;sG\u0016\u0014v.\u001e;fg*\u0011\u0011CE\u0001\u0007e>,H/Z:\u000b\u0005M!\u0012\u0001\u00026nCBT!!\u0006\f\u0002\u000b)\fW.Z:\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0004\n\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019y%M[3diB\u0011QEJ\u0007\u0002%%\u0011qE\u0005\u0002\u000b\u00156\u000b\u0005KU8vi\u0016\u001c\u0018!D1vi\",g\u000e^5dCR|'/F\u0001+!\tYc&D\u0001-\u0015\ti##\u0001\u0003iiR\u0004\u0018BA\u0018-\u00055\tU\u000f\u001e5f]RL7-\u0019;pe\u0006q\u0011-\u001e;iK:$\u0018nY1u_J\u0004\u0013aD;tKJ\u0004&o\u001c<jg&|g.\u001a:\u0011\u0005-\u001a\u0014B\u0001\u001b-\u0005A)6/\u001a:Qe>4\u0018n]5p]&tw-\u0001\u0005fm\u0016tGOQ;t!\t9$(D\u00019\u0015\tID#\u0001\u0004fm\u0016tGo]\u0005\u0003wa\u0012\u0001\"\u0012<f]R\u0014Uo\u001d\u0015\u0005\tu*e\t\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u00061\u0011N\u001c6fGRT\u0011AQ\u0001\u0006U\u00064\u0018\r_\u0005\u0003\t~\u0012QAT1nK\u0012\fQA^1mk\u0016\f\u0013aR\u0001\u0005\u00156\u000b\u0005+\u0001\bqkND7+\u001a:jC2L'0\u001a:\u0011\u0005)kU\"A&\u000b\u00051\u0013\u0012\u0001\u00026t_:L!AT&\u0003\u001dA+8\u000f[*fe&\fG.\u001b>fe\u0006\u0001B/\u001f9f'R\fG/\u001a$bGR|'/\u001f\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000baa\u00195b]\u001e,'BA+\u0013\u0003\r\t\u0007/[\u0005\u0003/J\u0013\u0001\u0003V=qKN#\u0018\r^3GC\u000e$xN]=\u0002\u001f\u0011,G.Z4bi&|gn\u0015;pe\u0016\u0004\"A\u00170\u000e\u0003mS!!\u0016/\u000b\u0005u#\u0012\u0001B;tKJL!aX.\u0003\u001f\u0011+G.Z4bi&|gn\u0015;pe\u0016\fa\u0001P5oSRtDc\u00022eQ&\\G.\u001c\t\u0003G\u0002i\u0011\u0001\u0005\u0005\u0006Q!\u0001\rA\u000b\u0015\u0005Iv*e-I\u0001h\u0003!\u0011fiQ\u00179mI\n\u0004\"B\u0019\t\u0001\u0004\u0011\u0004\"B\u001b\t\u0001\u00041\u0004\u0006B5>\u000b\u001aCQ\u0001\u0013\u0005A\u0002%CQa\u0014\u0005A\u0002ACQ\u0001\u0017\u0005A\u0002eC#\u0001C8\u0011\u0005y\u0002\u0018BA9@\u0005\u0019IeN[3diR\t1\u000fE\u0002usnl\u0011!\u001e\u0006\u0003m^\faa\u001d;sK\u0006l'B\u0001=!\u0003\u0011)H/\u001b7\n\u0005i,(AB*ue\u0016\fW\u000e\u0005\u0002&y&\u0011QP\u0005\u0002\n\u00156\u000b\u0005KU8vi\u0016\f\u0011\u0002[1oI2,7kU#\u0015\r\u0005\u0005\u00111DA\u0019!\u0019\t\u0019!!\u0005\u0002\u00165\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005qk\nd\u0017n\u001d5fe*!\u00111BA\u0007\u0003\u0011\u0019wN]3\u000b\u0005\u0005=\u0011a\u0002:fC\u000e$xN]\u0005\u0005\u0003'\t)A\u0001\u0003N_:|\u0007cA\u000f\u0002\u0018%\u0019\u0011\u0011\u0004\u0010\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003;Q\u0001\u0019AA\u0010\u0003\u001d\u0011X-];fgR\u0004B!!\t\u0002.5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0004tKJ4XM\u001d\u0006\u0004[\u0005%\"\u0002BA\u0016\u0003\u001b\tQA\\3uifLA!a\f\u0002$\t\t\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKF,Xm\u001d;\t\u000f\u0005M\"\u00021\u0001\u00026\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002\"\u0005]\u0012\u0002BA\u001d\u0003G\u0011!\u0003\u0013;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\u0006Y!/Z4jgR,'oU*F)!\ty$a\u0016\u0002Z\u0005%\u0004CBA!\u0003\u0013\ni%\u0004\u0002\u0002D)!\u0011qAA#\u0015\u0011\t9%!\u0003\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005-\u00131\t\u0002\u0006'6{gn\u001c\t\u0005\u0003\u001f\n\u0019&\u0004\u0002\u0002R)\u0011\u0011qI\u0005\u0005\u0003+\n\tF\u0001\u0003V]&$\bbBA\u001a\u0017\u0001\u0007\u0011Q\u0007\u0005\b\u00037Z\u0001\u0019AA/\u0003\u001d\u0019Xm]:j_:\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\"\u0012aB7bS2\u0014w\u000e_\u0005\u0005\u0003O\n\tG\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\t\u000f\u0005-4\u00021\u0001\u0002n\u00059q\u000e\u001d;j_:\u001c\bcA2\u0002p%\u0019\u0011\u0011\u000f\t\u0003%\u00153XM\u001c;T_V\u00148-Z(qi&|gn]\u0001\u000bCN\u001c6+R#wK:$H\u0003BA<\u0003\u001b\u0003B!!\u001f\u0002\b:!\u00111PAB!\u0011\ti(!\u0015\u000e\u0005\u0005}$bAAA5\u00051AH]8pizJA!!\"\u0002R\u00051\u0001K]3eK\u001aLA!!#\u0002\f\n11\u000b\u001e:j]\u001eTA!!\"\u0002R!9\u0011q\u0012\u0007A\u0002\u0005E\u0015aD8vi\n|WO\u001c3NKN\u001c\u0018mZ3\u0011\t\u0005M\u0015qS\u0007\u0003\u0003+S1!a\u0003\u0013\u0013\u0011\tI*!&\u0003\u001f=+HOY8v]\u0012lUm]:bO\u0016\f!\u0005[1oI2,7i\u001c8oK\u000e$\u0018n\u001c8FgR\f'\r\\5tQ6,g\u000e^#se>\u0014HCBAP\u0003C\u000b9\f\u0005\u0004\u0002B\u0005%\u0013Q\u0003\u0005\b\u0003Gk\u0001\u0019AAS\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0002(\u0006Ef\u0002BAU\u0003[sA!! \u0002,&\u0011\u0011qI\u0005\u0005\u0003_\u000b\t&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0016Q\u0017\u0002\n)\"\u0014xn^1cY\u0016TA!a,\u0002R!9\u00111G\u0007A\u0002\u0005U\u0012A\u0004:fgB|g\u000e\u001a#fi\u0006LGn\u001d\u000b\u0007\u0003?\u000bi,a0\t\u000f\u0005Mb\u00021\u0001\u00026!9\u0011\u0011\u0019\bA\u0002\u0005\r\u0017a\u00023fi\u0006LGn\u001d\t\u0005\u0003'\u000b)-\u0003\u0003\u0002H\u0006U%A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d")
public class EventSourceRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;
    private final DelegationStore delegationStore;

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/eventSource")).action((request, response) -> this.handleSSE(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/eventSource")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleSSE(HttpServerRequest request, HttpServerResponse response) {
        return ((SMono)new EventSourceOptionsFactory(this.typeStateFactory).forRequest(request).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)options -> SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.registerSSE(response, (MailboxSession)mailboxSession, (EventSourceOptions)options))))).onErrorResume((Function1 & Serializable)throwable -> this.handleConnectionEstablishmentError((Throwable)throwable, response)).asJava().then();
    }

    private SMono<BoxedUnit> registerSSE(HttpServerResponse response, MailboxSession session, EventSourceOptions options) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux<PingMessage> qual$1 = options.pingPolicy().asFlux();
        Function1 & Serializable x$1 = (Function1 & Serializable)ping -> {
            EventSourceRoutes.$anonfun$registerSSE$1(context, ping);
            return BoxedUnit.UNIT;
        };
        Option x$2 = qual$1.subscribe$default$2();
        Option x$3 = qual$1.subscribe$default$3();
        Disposable pingDisposable = qual$1.subscribe((Function1)x$1, x$2, x$3);
        SMono$.MODULE$.just((Object)session.getUser()).concatWith((Publisher)SFlux$.MODULE$.fromPublisher(this.delegationStore.delegatedUsers(session.getUser()))).map((Function1 & Serializable)username -> AccountIdRegistrationKey$.MODULE$.of((Username)username)).collectSeq().flatMap((Function1 & Serializable)keys -> SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener(options.types(), context.outbound()), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)keys).asJavaCollection()))).doOnNext((Function1 & Serializable)newRegistration -> {
            context.withRegistration(newRegistration);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return SMono$.MODULE$.apply((Publisher)response.addHeader((CharSequence)"Connection", (CharSequence)"keep-alive").sse().sendString((Publisher)options.closeAfter().applyOn((SFlux<OutboundMessage>)SFlux$.MODULE$.apply((Publisher)sink.asFlux())).map((Function1 & Serializable)outboundMessage -> this.asSSEEvent((OutboundMessage)outboundMessage)), StandardCharsets.UTF_8).then().doFinally(x$5 -> context.clean()).doFinally(x$6 -> pingDisposable.dispose()).then()).then();
    }

    private String asSSEEvent(OutboundMessage outboundMessage) {
        String string2;
        OutboundMessage outboundMessage2 = outboundMessage;
        if (outboundMessage2 instanceof PingMessage) {
            string2 = "ping";
        } else if (outboundMessage2 instanceof StateChange) {
            string2 = "state";
        } else {
            throw new MatchError((Object)outboundMessage2);
        }
        String event = string2;
        return new StringBuilder(16).append("event: ").append(event).append("\ndata: ").append(Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(outboundMessage))).append("\n\n").toString();
    }

    private SMono<Void> handleConnectionEstablishmentError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse response, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)response.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public static final /* synthetic */ void $anonfun$registerSSE$1(ClientContext context$1, PingMessage ping) {
        context$1.outbound().emitNext((Object)ping, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Inject
    public EventSourceRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, PushSerializer pushSerializer, TypeStateFactory typeStateFactory, DelegationStore delegationStore) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
        this.delegationStore = delegationStore;
    }
}

