/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.search.Combinator;

@JsonDeserialize(as=QueryDTO.class)
public class QueryDTO
implements QueryElement {
    private final String combinator;
    private final List<QueryElement> criteria;

    @VisibleForTesting
    static QueryDTO and(QueryElement ... queryElements) {
        return new QueryDTO(Combinator.AND.getValue(), (List<QueryElement>)ImmutableList.copyOf((Object[])queryElements));
    }

    @JsonCreator
    public QueryDTO(@JsonProperty(value="combinator") String combinator, @JsonProperty(value="criteria") List<QueryElement> criteria) {
        this.combinator = combinator;
        this.criteria = criteria;
    }

    public String getCombinator() {
        return this.combinator;
    }

    public List<QueryElement> getCriteria() {
        return this.criteria;
    }

    public final boolean equals(Object o) {
        if (o instanceof QueryDTO) {
            QueryDTO queryDTO = (QueryDTO)o;
            return Objects.equals(this.combinator, queryDTO.getCombinator()) && Objects.equals(this.criteria, queryDTO.getCriteria());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.combinator, this.criteria);
    }
}

