/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class SimpleMatchingRule
extends MatchingRule {
    private static final long serialVersionUID = -7221506185552250694L;

    @Override
    public boolean valuesMatch(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        return this.normalize(value1).equals(this.normalize(value2));
    }

    @Override
    public boolean matchesAnyValue(@NotNull ASN1OctetString assertionValue, @NotNull ASN1OctetString[] attributeValues) throws LDAPException {
        if (assertionValue == null || attributeValues == null || attributeValues.length == 0) {
            return false;
        }
        ASN1OctetString normalizedAssertionValue = this.normalize(assertionValue);
        for (ASN1OctetString attributeValue : attributeValues) {
            try {
                if (!normalizedAssertionValue.equalsIgnoreType(this.normalize(attributeValue))) continue;
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    @Override
    public boolean matchesSubstring(@NotNull ASN1OctetString value, @Nullable ASN1OctetString subInitial, @Nullable ASN1OctetString[] subAny, @Nullable ASN1OctetString subFinal) throws LDAPException {
        int i;
        byte[] normValue = this.normalize(value).getValue();
        int pos = 0;
        if (subInitial != null) {
            byte[] normSubInitial = this.normalizeSubstring(subInitial, (byte)-128).getValue();
            if (normValue.length < normSubInitial.length) {
                return false;
            }
            for (i = 0; i < normSubInitial.length; ++i) {
                if (normValue[i] == normSubInitial[i]) continue;
                return false;
            }
            pos = normSubInitial.length;
        }
        if (subAny != null) {
            byte[][] normSubAny = new byte[subAny.length][];
            for (i = 0; i < subAny.length; ++i) {
                normSubAny[i] = this.normalizeSubstring(subAny[i], (byte)-127).getValue();
            }
            for (byte[] b : normSubAny) {
                if (b.length == 0) continue;
                boolean match = false;
                int subEndLength = normValue.length - b.length;
                while (pos <= subEndLength) {
                    match = true;
                    for (int i2 = 0; i2 < b.length; ++i2) {
                        if (normValue[pos + i2] == b[i2]) continue;
                        match = false;
                        break;
                    }
                    if (match) {
                        pos += b.length;
                        break;
                    }
                    ++pos;
                }
                if (match) continue;
                return false;
            }
        }
        if (subFinal != null) {
            byte[] normSubFinal = this.normalizeSubstring(subFinal, (byte)-126).getValue();
            int finalStartPos = normValue.length - normSubFinal.length;
            if (finalStartPos < pos) {
                return false;
            }
            int i3 = 0;
            while (i3 < normSubFinal.length) {
                if (normValue[finalStartPos] != normSubFinal[i3]) {
                    return false;
                }
                ++i3;
                ++finalStartPos;
            }
        }
        return true;
    }

    @Override
    public int compareValues(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        byte[] normValue1 = this.normalize(value1).getValue();
        byte[] normValue2 = this.normalize(value2).getValue();
        int minLength = Math.min(normValue1.length, normValue2.length);
        for (int i = 0; i < minLength; ++i) {
            int b1 = normValue1[i] & 0xFF;
            int b2 = normValue2[i] & 0xFF;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return normValue1.length - normValue2.length;
    }
}

