/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.FieldName;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.field.address.DefaultAddressParser;
import org.apache.james.mime4j.internal.AbstractEntityBuilder;
import org.apache.james.mime4j.internal.ParserStreamContentHandler;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.NameValuePair;

public interface Message
extends Entity,
Body {
    public String getMessageId();

    public String getSubject();

    public Date getDate();

    public Mailbox getSender();

    public MailboxList getFrom();

    public AddressList getTo();

    public AddressList getCc();

    public AddressList getBcc();

    public AddressList getReplyTo();

    public static class Builder
    extends AbstractEntityBuilder {
        private MimeConfig config;
        private DecodeMonitor monitor;
        private BodyDescriptorBuilder bodyDescBuilder;
        private FieldParser<?> fieldParser;
        private BodyFactory bodyFactory;
        private boolean flatMode;
        private boolean rawContent;

        private Builder() {
        }

        public static Builder of() {
            return new Builder();
        }

        public static Builder of(Message other) {
            return new Builder().copy(other);
        }

        public static Builder of(InputStream is) throws IOException {
            return new Builder().parse(is);
        }

        public Builder use(MimeConfig config) {
            this.config = config;
            return this;
        }

        public Builder use(DecodeMonitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public Builder use(BodyDescriptorBuilder bodyDescBuilder) {
            this.bodyDescBuilder = bodyDescBuilder;
            return this;
        }

        public Builder use(FieldParser<?> fieldParser) {
            this.fieldParser = fieldParser;
            return this;
        }

        public Builder use(BodyFactory bodyFactory) {
            this.bodyFactory = bodyFactory;
            return this;
        }

        public Builder enableFlatMode() {
            this.flatMode = true;
            return this;
        }

        public Builder disableFlatMode() {
            this.flatMode = false;
            return this;
        }

        public Builder enableContentDecoding() {
            this.rawContent = false;
            return this;
        }

        public Builder disableContentDecoding() {
            this.rawContent = true;
            return this;
        }

        public Builder copy(Message other) {
            if (other == null) {
                return this;
            }
            this.clearFields();
            Header otherHeader = other.getHeader();
            if (otherHeader != null) {
                List<Field> otherFields = otherHeader.getFields();
                for (Field field2 : otherFields) {
                    this.addField(field2);
                }
            }
            Body body = null;
            Body otherBody = other.getBody();
            if (otherBody instanceof Message) {
                body = Builder.of((Message)otherBody).build();
            } else if (otherBody instanceof Multipart) {
                body = MultipartBuilder.createCopy((Multipart)otherBody).build();
            } else if (otherBody instanceof SingleBody) {
                body = ((SingleBody)otherBody).copy();
            }
            this.setBody(body);
            return this;
        }

        @Override
        public Builder setField(Field field2) {
            super.setField(field2);
            return this;
        }

        @Override
        public Builder addField(Field field2) {
            super.addField(field2);
            return this;
        }

        @Override
        public Builder removeFields(String name) {
            super.removeFields(name);
            return this;
        }

        @Override
        public Builder clearFields() {
            super.clearFields();
            return this;
        }

        @Override
        public Builder setContentTransferEncoding(String contentTransferEncoding) {
            super.setContentTransferEncoding(contentTransferEncoding);
            return this;
        }

        @Override
        public Builder setContentType(String mimeType, NameValuePair ... parameters) {
            super.setContentType(mimeType, parameters);
            return this;
        }

        @Override
        public Builder setContentDisposition(String dispositionType) {
            super.setContentDisposition(dispositionType);
            return this;
        }

        @Override
        public Builder setContentDisposition(String dispositionType, String filename) {
            super.setContentDisposition(dispositionType, filename);
            return this;
        }

        @Override
        public Builder setContentDisposition(String dispositionType, String filename, long size) {
            super.setContentDisposition(dispositionType, filename, size);
            return this;
        }

        @Override
        public Builder setContentDisposition(String dispositionType, String filename, long size, Date creationDate, Date modificationDate, Date readDate) {
            super.setContentDisposition(dispositionType, filename, size, creationDate, modificationDate, readDate);
            return this;
        }

        @Override
        public Builder setBody(Body body) {
            super.setBody(body);
            return this;
        }

        @Override
        public Builder setBody(TextBody textBody) {
            super.setBody(textBody);
            return this;
        }

        @Override
        public Builder setBody(BinaryBody binaryBody) {
            super.setBody(binaryBody);
            return this;
        }

        @Override
        public Builder setBody(Multipart multipart) {
            super.setBody(multipart);
            return this;
        }

        @Override
        public Builder setBody(Message message) {
            super.setBody(message);
            return this;
        }

        public Builder setBody(String text, Charset charset) throws IOException {
            return this.setBody(text, null, charset);
        }

        public Builder setBody(String text, String subtype, Charset charset) throws IOException {
            String mimeType = "text/" + (subtype != null ? subtype : "plain");
            if (charset != null) {
                this.setField(Fields.contentType(mimeType, new NameValuePair("charset", charset.name())));
            } else {
                this.setField(Fields.contentType(mimeType));
            }
            TextBody textBody = this.bodyFactory != null ? this.bodyFactory.textBody(InputStreams.create(text, charset), charset != null ? charset.name() : null) : BasicBodyFactory.INSTANCE.textBody(text, charset);
            return this.setBody((Body)textBody);
        }

        public Builder setBody(byte[] bin, String mimeType) throws IOException {
            this.setField(Fields.contentType(mimeType != null ? mimeType : "application/octet-stream"));
            BinaryBody binBody = this.bodyFactory != null ? this.bodyFactory.binaryBody(InputStreams.create(bin)) : BasicBodyFactory.INSTANCE.binaryBody(bin);
            return this.setBody((Body)binBody);
        }

        public String getMessageId() {
            Object field2 = this.obtainField(FieldName.MESSAGE_ID_LOWERCASE);
            return field2 != null ? field2.getBody() : null;
        }

        public Builder generateMessageId(String hostname) {
            if (hostname == null) {
                this.removeFields("Message-ID");
            } else {
                this.setField(Fields.generateMessageId(hostname));
            }
            return this;
        }

        public Builder setMessageId(String messageId) {
            if (messageId == null) {
                this.removeFields("Message-ID");
            } else {
                this.setField(Fields.messageId(messageId));
            }
            return this;
        }

        public String getSubject() {
            UnstructuredField field2 = (UnstructuredField)this.obtainField(FieldName.SUBJECT_LOWERCASE);
            return field2 != null ? field2.getValue() : null;
        }

        public Builder setSubject(String subject) {
            if (subject == null) {
                this.removeFields("Subject");
            } else {
                this.setField(Fields.subject(subject));
            }
            return this;
        }

        public Date getDate() {
            DateTimeField field2 = (DateTimeField)this.obtainField(FieldName.DATE_LOWERCASE);
            return field2 != null ? field2.getDate() : null;
        }

        public Builder setDate(Date date) {
            return this.setDate(date, null);
        }

        public Builder setDate(Date date, TimeZone zone) {
            if (date == null) {
                this.removeFields("Date");
            } else {
                this.setField(Fields.date("Date", date, zone));
            }
            return this;
        }

        public Mailbox getSender() {
            return this.getMailbox(FieldName.SENDER_LOWERCASE);
        }

        public Builder setSender(Mailbox sender) {
            return this.setMailbox("Sender", sender);
        }

        public Builder setSender(String sender) throws ParseException {
            return this.setMailbox("Sender", sender);
        }

        public MailboxList getFrom() {
            return this.getMailboxList(FieldName.FROM_LOWERCASE);
        }

        public Builder setFrom(Mailbox from) {
            return this.setMailboxList("From", from);
        }

        public Builder setFrom(String from) throws ParseException {
            return this.setMailboxList("From", from);
        }

        public Builder setFrom(Mailbox ... from) {
            return this.setMailboxList("From", from);
        }

        public Builder setFrom(String ... from) throws ParseException {
            return this.setMailboxList("From", from);
        }

        public Builder setFrom(Collection<Mailbox> from) {
            return this.setMailboxList("From", from);
        }

        public AddressList getTo() {
            return this.getAddressList(FieldName.TO_LOWERCASE);
        }

        public Builder setTo(Address to) {
            return this.setAddressList("To", to);
        }

        public Builder setTo(String to) throws ParseException {
            return this.setAddressList("To", to);
        }

        public Builder setTo(Address ... to) {
            return this.setAddressList("To", to);
        }

        public Builder setTo(String ... to) throws ParseException {
            return this.setAddressList("To", to);
        }

        public Builder setTo(Collection<? extends Address> to) {
            return this.setAddressList("To", to);
        }

        public AddressList getCc() {
            return this.getAddressList(FieldName.CC_LOWERCASE);
        }

        public Builder setCc(Address cc) {
            return this.setAddressList("Cc", cc);
        }

        public Builder setCc(Address ... cc) {
            return this.setAddressList("Cc", cc);
        }

        public Builder setCc(Collection<? extends Address> cc) {
            return this.setAddressList("Cc", cc);
        }

        public AddressList getBcc() {
            return this.getAddressList(FieldName.BCC_LOWERCASE);
        }

        public Builder setBcc(Address bcc) {
            return this.setAddressList("Bcc", bcc);
        }

        public Builder setBcc(Address ... bcc) {
            return this.setAddressList("Bcc", bcc);
        }

        public Builder setBcc(Collection<? extends Address> bcc) {
            return this.setAddressList("Bcc", bcc);
        }

        public AddressList getReplyTo() {
            return this.getAddressList(FieldName.REPLY_TO_LOWERCASE);
        }

        public Builder setReplyTo(Address replyTo) {
            return this.setAddressList("Reply-To", replyTo);
        }

        public Builder setReplyTo(Address ... replyTo) {
            return this.setAddressList("Reply-To", replyTo);
        }

        public Builder setReplyTo(Collection<? extends Address> replyTo) {
            return this.setAddressList("Reply-To", replyTo);
        }

        public Builder parse(InputStream is) throws IOException {
            BodyDescriptorBuilder currentBodyDescBuilder;
            DecodeMonitor currentMonitor;
            MimeConfig currentConfig = this.config != null ? this.config : MimeConfig.DEFAULT;
            boolean strict = currentConfig.isStrictParsing();
            DecodeMonitor decodeMonitor = this.monitor != null ? this.monitor : (currentMonitor = strict ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
            BodyDescriptorBuilder bodyDescriptorBuilder = this.bodyDescBuilder != null ? this.bodyDescBuilder : (currentBodyDescBuilder = new DefaultBodyDescriptorBuilder(null, this.fieldParser != null ? this.fieldParser : (strict ? DefaultFieldParser.getParser() : LenientFieldParser.getParser()), currentMonitor));
            BodyFactory currentBodyFactory = this.bodyFactory != null ? this.bodyFactory : new BasicBodyFactory(!strict);
            MimeStreamParser parser = new MimeStreamParser(currentConfig, currentMonitor, currentBodyDescBuilder);
            MessageImpl message = new MessageImpl();
            parser.setContentHandler(new ParserStreamContentHandler(message, currentBodyFactory));
            parser.setContentDecoding(!this.rawContent);
            if (this.flatMode) {
                parser.setFlat();
            }
            try {
                parser.parse(is);
            }
            catch (MimeException e) {
                throw new MimeIOException(e);
            }
            this.clearFields();
            List<Field> fields = message.getHeader().getFields();
            for (Field field2 : fields) {
                this.addField(field2);
            }
            this.setBody(message.getBody());
            return this;
        }

        public Message build() {
            MessageImpl message = new MessageImpl();
            HeaderImpl header = new HeaderImpl();
            message.setHeader(header);
            if (!this.containsField(FieldName.MIME_VERSION_LOWERCASE)) {
                header.setField(Fields.version("1.0"));
            }
            for (Field field2 : this.getFields()) {
                header.addField(field2);
            }
            message.setBody(this.getBody());
            return message;
        }

        private Mailbox getMailbox(String fieldName) {
            MailboxField field2 = (MailboxField)this.obtainField(fieldName);
            return field2 != null ? field2.getMailbox() : null;
        }

        private Builder setMailbox(String fieldName, Mailbox mailbox) {
            if (mailbox == null) {
                this.removeFields(fieldName);
            } else {
                this.setField(Fields.mailbox(fieldName, mailbox));
            }
            return this;
        }

        private Builder setMailbox(String fieldName, String mailbox) throws ParseException {
            if (mailbox == null) {
                this.removeFields(fieldName);
            } else {
                this.setField(Fields.mailbox(fieldName, DefaultAddressParser.DEFAULT.parseMailbox(mailbox)));
            }
            return this;
        }

        private MailboxList getMailboxList(String fieldName) {
            MailboxListField field2 = (MailboxListField)this.obtainField(fieldName);
            return field2 != null ? field2.getMailboxList() : null;
        }

        private Builder setMailboxList(String fieldName, Mailbox mailbox) {
            return this.setMailboxList(fieldName, mailbox == null ? null : Collections.singleton(mailbox));
        }

        private Builder setMailboxList(String fieldName, String mailbox) throws ParseException {
            return this.setMailboxList(fieldName, mailbox == null ? null : DefaultAddressParser.DEFAULT.parseMailbox(mailbox));
        }

        private Builder setMailboxList(String fieldName, Mailbox ... mailboxes) {
            return this.setMailboxList(fieldName, mailboxes == null ? null : Arrays.asList(mailboxes));
        }

        private List<Mailbox> parseMailboxes(String ... mailboxes) throws ParseException {
            if (mailboxes == null || mailboxes.length == 0) {
                return null;
            }
            ArrayList<Mailbox> list = new ArrayList<Mailbox>();
            for (String mailbox : mailboxes) {
                list.add(DefaultAddressParser.DEFAULT.parseMailbox(mailbox));
            }
            return list;
        }

        private Builder setMailboxList(String fieldName, String ... mailboxes) throws ParseException {
            return this.setMailboxList(fieldName, this.parseMailboxes(mailboxes));
        }

        private Builder setMailboxList(String fieldName, Collection<Mailbox> mailboxes) {
            if (mailboxes == null || mailboxes.isEmpty()) {
                this.removeFields(fieldName);
            } else {
                this.setField(Fields.mailboxList(fieldName, mailboxes));
            }
            return this;
        }

        private AddressList getAddressList(String fieldName) {
            AddressListField field2 = (AddressListField)this.obtainField(fieldName);
            return field2 != null ? field2.getAddressList() : null;
        }

        private Builder setAddressList(String fieldName, Address address) {
            return this.setAddressList(fieldName, address == null ? null : Collections.singleton(address));
        }

        private Builder setAddressList(String fieldName, String address) throws ParseException {
            return this.setAddressList(fieldName, (Address)(address == null ? null : DefaultAddressParser.DEFAULT.parseMailbox(address)));
        }

        private Builder setAddressList(String fieldName, Address ... addresses) {
            return this.setAddressList(fieldName, addresses == null ? null : Arrays.asList(addresses));
        }

        private List<Address> parseAddresses(String ... addresses) throws ParseException {
            if (addresses == null || addresses.length == 0) {
                return null;
            }
            ArrayList<Address> list = new ArrayList<Address>();
            for (String address : addresses) {
                list.add(DefaultAddressParser.DEFAULT.parseAddress(address));
            }
            return list;
        }

        private Builder setAddressList(String fieldName, String ... addresses) throws ParseException {
            return this.setAddressList(fieldName, this.parseAddresses(addresses));
        }

        private Builder setAddressList(String fieldName, Collection<? extends Address> addresses) {
            if (addresses == null || addresses.isEmpty()) {
                this.removeFields(fieldName);
            } else {
                this.setField(Fields.addressList(fieldName, addresses));
            }
            return this;
        }
    }
}

