/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ChainedResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture {
    private volatile ResultSetFuture source;

    ChainedResultSetFuture() {
    }

    void setSource(ResultSetFuture source) {
        if (this.isCancelled()) {
            source.cancel(false);
        }
        this.source = source;
        GuavaCompatibility.INSTANCE.addCallback(source, new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                ChainedResultSetFuture.this.set(result);
            }

            public void onFailure(Throwable t) {
                ChainedResultSetFuture.this.setException(t);
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.source == null || this.source.cancel(mayInterruptIfRunning)) && super.cancel(mayInterruptIfRunning);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return (ResultSet)Uninterruptibles.getUninterruptibly((Future)((Object)this));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return (ResultSet)Uninterruptibles.getUninterruptibly((Future)((Object)this), (long)timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }
}

