/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OptionalUtils {
    public static <T> Optional<T> executeIfEmpty(Optional<T> optional, Operation operation) {
        if (!optional.isPresent()) {
            operation.perform();
        }
        return optional;
    }

    public static <T> Stream<T> toStream(Optional<T> optional) {
        return optional.map(Stream::of).orElse(Stream.of(new Object[0]));
    }

    public static <T> ImmutableList<T> toList(Optional<T> optional) {
        return optional.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    public static <T> ImmutableSet<T> toSet(Optional<T> optional) {
        return optional.map(ImmutableSet::of).orElse(ImmutableSet.of());
    }

    @SafeVarargs
    public static <T> Optional<T> or(Optional<T> ... optionals) {
        return OptionalUtils.orStream(Arrays.stream(optionals));
    }

    @SafeVarargs
    public static <T> Optional<T> orSuppliers(Supplier<Optional<T>> ... suppliers) {
        return OptionalUtils.orStream(Arrays.stream(suppliers).map(Supplier::get));
    }

    private static <T> Optional<T> orStream(Stream<Optional<T>> stream) {
        return stream.filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public static <T> boolean containsDifferent(Optional<T> requestValue, T storeValue) {
        return requestValue.filter(value -> !value.equals(storeValue)).isPresent();
    }

    public static <T, U> boolean matches(Optional<T> optional1, Optional<U> optional2, BiPredicate<T, U> biPredicate) {
        return optional1.map(value1 -> optional2.map(value2 -> biPredicate.test(value1, value2)).orElse(false)).orElse(false);
    }

    @FunctionalInterface
    public static interface Operation {
        public void perform();
    }
}

